/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.repository.XltRepositoryException;
import com.xebialabs.xltest.service.EventRepository;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRepositoryImpl
implements EventRepository {
    private static final Logger LOG = LoggerFactory.getLogger(EventRepositoryImpl.class);
    private final Object client;
    private final Method insertMethod;
    private final Method queryMethod;

    public EventRepositoryImpl(Object client) throws NoSuchMethodException {
        this.client = client;
        this.insertMethod = client.getClass().getDeclaredMethod("insert", String.class, String.class);
        this.queryMethod = client.getClass().getDeclaredMethod("query", String.class);
    }

    public void insert(Event event) {
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        String content = jsonProvider.toJson((Object)event.getProperties());
        try {
            this.insertMethod.invoke(this.client, event.getType(), content);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XltRepositoryException("Problem encountered in inserting event " + event, (Throwable)e);
        }
    }

    public List<Event> query(String query) {
        try {
            LOG.debug("About to query event repository with query {}", (Object)query);
            return this.parseElasticSearchJson((List)this.queryMethod.invoke(this.client, query));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to read from internal store", e);
        }
    }

    private List<Event> parseElasticSearchJson(List<String> hits) {
        if (hits == null) {
            return Collections.emptyList();
        }
        ArrayList<Event> retrievedEvents = new ArrayList<Event>(hits.size());
        for (String hit : hits) {
            Map object = (Map)JsonProviderFactory.createProvider().parse(hit);
            retrievedEvents.add(new Event(object));
        }
        return retrievedEvents;
    }
}

