/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils.glob;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Globbit {
    private static final Logger LOG = LoggerFactory.getLogger(Globbit.class);

    public static Collection<OverthereFile> find(OverthereFile searchRoot, FileMatcher fileMatcher) {
        return Globbit.matchingFiles(searchRoot, fileMatcher);
    }

    private static List<OverthereFile> matchingFiles(OverthereFile workingDirectoryOverthereFile, FileMatcher matcher) {
        List<OverthereFile> allFilesInWorkingDirectory = Globbit.getPathTree(workingDirectoryOverthereFile);
        ArrayList<OverthereFile> matched = new ArrayList<OverthereFile>();
        String fileSeparator = workingDirectoryOverthereFile.getConnection().getHostOperatingSystem().getFileSeparator();
        String workingDirectory = workingDirectoryOverthereFile.getPath() + fileSeparator;
        for (OverthereFile file : allFilesInWorkingDirectory) {
            int indexOf;
            String path = file.getPath();
            String relativePath = path.substring(indexOf = path.indexOf(workingDirectory) + workingDirectory.length());
            String normalizedPath = relativePath.replace("\\", "/");
            if (!matcher.match(normalizedPath)) continue;
            matched.add(file);
        }
        return matched;
    }

    private static List<OverthereFile> getPathTree(OverthereFile file) {
        if (!file.isDirectory()) {
            return Collections.singletonList(file);
        }
        ArrayList<OverthereFile> result = new ArrayList<OverthereFile>();
        result.add(file);
        for (OverthereFile child : file.listFiles()) {
            result.addAll(Globbit.getPathTree(child));
        }
        return result;
    }
}

