/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions.js;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;

public class XVariableContext {
    public final Type type;
    public final String text;
    public final int integer;
    static final /* synthetic */ boolean $assertionsDisabled;

    private XVariableContext(Type c, String s, int i) {
        this.type = c;
        this.text = s;
        this.integer = i;
    }

    public static final XVariableContext[] parse(String variable) {
        char[] text = variable.toCharArray();
        ArrayList<XVariableContext> contexts = new ArrayList<XVariableContext>();
        int i = XVariableContext.addMember(text, 0, contexts);
        while (i < text.length) {
            if (text[i] == '[') {
                i = text[++i] == '\'' ? XVariableContext.addStringIndex(text, i, contexts) : XVariableContext.addIntIndex(text, i, contexts);
                ++i;
                continue;
            }
            i = XVariableContext.addMember(text, i + 1, contexts);
        }
        return contexts.toArray(new XVariableContext[contexts.size()]);
    }

    private static int addMember(char[] text, int i, List<XVariableContext> contexts) {
        int j;
        for (j = i + 1; j < text.length && text[j] != '[' && text[j] != '.'; ++j) {
        }
        contexts.add(new XVariableContext(Type.MEMBER, new String(text, i, j - i), -1));
        return j;
    }

    private static int addStringIndex(char[] text, int i, List<XVariableContext> contexts) {
        int j = ++i;
        while (text[j] != '\'') {
            if (text[j] == '\\') {
                ++j;
            }
            ++j;
        }
        StringBuffer buf = new StringBuffer(j - i);
        while (i < j) {
            if (text[i] == '\\') {
                ++i;
            }
            buf.append(text[i]);
            ++i;
        }
        contexts.add(new XVariableContext(Type.STR_INDEX, buf.toString(), -1));
        return j + 1;
    }

    private static int addIntIndex(char[] text, int i, List<XVariableContext> contexts) {
        int j = i + 1;
        while (text[j] != ']') {
            ++j;
        }
        int index = Integer.parseInt(new String(text, i, j - i));
        contexts.add(new XVariableContext(Type.INT_INDEX, null, index));
        return j;
    }

    static {
        boolean bl = $assertionsDisabled = !XVariableContext.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Version.CURRENT.luceneVersion != org.apache.lucene.util.Version.LUCENE_4_9) {
            throw new AssertionError((Object)"Remove this code once we upgrade to Lucene 4.10 (LUCENE-5806)");
        }
    }

    public static enum Type {
        MEMBER,
        STR_INDEX,
        INT_INDEX;

    }
}

