/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericDateTokenizer;

public class NumericDateAnalyzer
extends NumericAnalyzer<NumericDateTokenizer> {
    private static final Map<String, IntObjectOpenHashMap<NamedAnalyzer>> globalAnalyzers = Maps.newHashMap();
    private final int precisionStep;
    private final DateTimeFormatter dateTimeFormatter;

    public static synchronized NamedAnalyzer buildNamedAnalyzer(FormatDateTimeFormatter formatter, int precisionStep) {
        NamedAnalyzer namedAnalyzer;
        IntObjectOpenHashMap<NamedAnalyzer> precisionMap = globalAnalyzers.get(formatter.format());
        if (precisionMap == null) {
            precisionMap = new IntObjectOpenHashMap();
            globalAnalyzers.put(formatter.format(), precisionMap);
        }
        if ((namedAnalyzer = precisionMap.get(precisionStep)) == null) {
            String name = "_date/" + (precisionStep == Integer.MAX_VALUE ? "max" : Integer.valueOf(precisionStep));
            namedAnalyzer = new NamedAnalyzer(name, AnalyzerScope.GLOBAL, new NumericDateAnalyzer(precisionStep, formatter.parser()));
            precisionMap.put(precisionStep, namedAnalyzer);
        }
        return namedAnalyzer;
    }

    public NumericDateAnalyzer(int precisionStep, DateTimeFormatter dateTimeFormatter) {
        this.precisionStep = precisionStep;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    protected NumericDateTokenizer createNumericTokenizer(Reader reader, char[] buffer) throws IOException {
        return new NumericDateTokenizer(reader, this.precisionStep, buffer, this.dateTimeFormatter);
    }
}

