/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeSource;
import org.elasticsearch.common.io.Streams;

public abstract class NumericTokenizer
extends Tokenizer {
    private final NumericTokenStream numericTokenStream;
    private final char[] buffer;
    protected final Object extra;
    private boolean started;

    private static final AttributeFactory delegatingAttributeFactory(final AttributeSource source) {
        return new AttributeFactory(){

            public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
                return (AttributeImpl)source.addAttribute(attClass);
            }
        };
    }

    protected NumericTokenizer(Reader reader, NumericTokenStream numericTokenStream, char[] buffer, Object extra) throws IOException {
        super(NumericTokenizer.delegatingAttributeFactory((AttributeSource)numericTokenStream), reader);
        this.numericTokenStream = numericTokenStream;
        Iterator it = numericTokenStream.getAttributeClassesIterator();
        while (it.hasNext()) {
            this.addAttribute((Class)it.next());
        }
        this.extra = extra;
        this.buffer = buffer;
        this.started = true;
    }

    public void reset() throws IOException {
        super.reset();
        this.started = false;
    }

    public final boolean incrementToken() throws IOException {
        if (!this.started) {
            int len = Streams.readFully(this.input, this.buffer);
            if (len == this.buffer.length && this.input.read() != -1) {
                throw new IOException("Cannot read numeric data larger than " + this.buffer.length + " chars");
            }
            this.setValue(this.numericTokenStream, new String(this.buffer, 0, len));
            this.numericTokenStream.reset();
            this.started = true;
        }
        return this.numericTokenStream.incrementToken();
    }

    public void end() throws IOException {
        super.end();
        this.numericTokenStream.end();
    }

    public void close() throws IOException {
        super.close();
        this.numericTokenStream.close();
    }

    protected abstract void setValue(NumericTokenStream var1, String var2);
}

