/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.AbstractAtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;

public class NumericDVAtomicFieldData
extends AbstractAtomicNumericFieldData {
    private final AtomicReader reader;
    private final String field;

    public NumericDVAtomicFieldData(AtomicReader reader, String field) {
        super(false);
        this.reader = reader;
        this.field = field;
    }

    @Override
    public void close() {
    }

    public long ramBytesUsed() {
        return -1L;
    }

    private DocValuesAndBits getDocValues() {
        try {
            NumericDocValues values = DocValues.getNumeric((AtomicReader)this.reader, (String)this.field);
            Bits docsWithField = DocValues.getDocsWithField((AtomicReader)this.reader, (String)this.field);
            return new DocValuesAndBits(values, docsWithField);
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public LongValues getLongValues() {
        final DocValuesAndBits docValues = this.getDocValues();
        return new LongValues(false){

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return docValues.docsWithField.get(docId) ? 1 : 0;
            }

            @Override
            public long nextValue() {
                return docValues.values.get(this.docId);
            }
        };
    }

    @Override
    public DoubleValues getDoubleValues() {
        final DocValuesAndBits docValues = this.getDocValues();
        return new DoubleValues(false){

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return docValues.docsWithField.get(docId) ? 1 : 0;
            }

            @Override
            public double nextValue() {
                return docValues.values.get(this.docId);
            }
        };
    }

    private static class DocValuesAndBits {
        final NumericDocValues values;
        final Bits docsWithField;

        DocValuesAndBits(NumericDocValues values, Bits docsWithField) {
            this.values = values;
            this.docsWithField = docsWithField;
        }
    }
}

