/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.collect.UpdateInPlaceMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.FieldMappersLookup;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;

public class DocumentFieldMappers
implements Iterable<FieldMapper> {
    private final DocumentMapper docMapper;
    private final FieldMappersLookup fieldMappers;
    private final FieldNameAnalyzer indexAnalyzer;
    private final FieldNameAnalyzer searchAnalyzer;
    private final FieldNameAnalyzer searchQuoteAnalyzer;

    public DocumentFieldMappers(@Nullable @IndexSettings Settings settings, DocumentMapper docMapper) {
        this.docMapper = docMapper;
        this.fieldMappers = new FieldMappersLookup(settings);
        this.indexAnalyzer = new FieldNameAnalyzer(UpdateInPlaceMap.of(MapperService.getFieldMappersCollectionSwitch(settings)), docMapper.indexAnalyzer());
        this.searchAnalyzer = new FieldNameAnalyzer(UpdateInPlaceMap.of(MapperService.getFieldMappersCollectionSwitch(settings)), docMapper.searchAnalyzer());
        this.searchQuoteAnalyzer = new FieldNameAnalyzer(UpdateInPlaceMap.of(MapperService.getFieldMappersCollectionSwitch(settings)), docMapper.searchQuotedAnalyzer());
    }

    public void addNewMappers(List<FieldMapper> newMappers) {
        this.fieldMappers.addNewMappers(newMappers);
        UpdateInPlaceMap.Mutator indexAnalyzersMutator = this.indexAnalyzer.analyzers().mutator();
        UpdateInPlaceMap.Mutator searchAnalyzersMutator = this.searchAnalyzer.analyzers().mutator();
        UpdateInPlaceMap.Mutator searchQuoteAnalyzersMutator = this.searchQuoteAnalyzer.analyzers().mutator();
        for (FieldMapper fieldMapper : newMappers) {
            if (fieldMapper.indexAnalyzer() != null) {
                indexAnalyzersMutator.put(fieldMapper.names().indexName(), fieldMapper.indexAnalyzer());
            }
            if (fieldMapper.searchAnalyzer() != null) {
                searchAnalyzersMutator.put(fieldMapper.names().indexName(), fieldMapper.searchAnalyzer());
            }
            if (fieldMapper.searchQuoteAnalyzer() == null) continue;
            searchQuoteAnalyzersMutator.put(fieldMapper.names().indexName(), fieldMapper.searchQuoteAnalyzer());
        }
        indexAnalyzersMutator.close();
        searchAnalyzersMutator.close();
        searchQuoteAnalyzersMutator.close();
    }

    @Override
    public UnmodifiableIterator<FieldMapper> iterator() {
        return this.fieldMappers.iterator();
    }

    public List<FieldMapper> mappers() {
        return this.fieldMappers.mappers();
    }

    public boolean hasMapper(FieldMapper fieldMapper) {
        return this.fieldMappers.mappers().contains(fieldMapper);
    }

    public FieldMappers name(String name) {
        return this.fieldMappers.name(name);
    }

    public FieldMappers indexName(String indexName) {
        return this.fieldMappers.indexName(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.fieldMappers.fullName(fullName);
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        return this.fieldMappers.simpleMatchToIndexNames(pattern);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        return this.fieldMappers.simpleMatchToFullName(pattern);
    }

    public FieldMappers smartName(String name) {
        return this.fieldMappers.smartName(name);
    }

    public FieldMapper smartNameFieldMapper(String name) {
        return this.fieldMappers.smartNameFieldMapper(name);
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer indexAnalyzer(Analyzer defaultAnalyzer) {
        return new FieldNameAnalyzer(this.indexAnalyzer.analyzers(), defaultAnalyzer);
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }
}

