/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.IntegerFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class TokenCountFieldMapper
extends IntegerFieldMapper {
    public static final String CONTENT_TYPE = "token_count";
    private NamedAnalyzer analyzer;

    protected TokenCountFieldMapper(FieldMapper.Names names, int precisionStep, float boost, FieldType fieldType, Boolean docValues, Integer nullValue, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, Settings fieldDataSettings, Settings indexSettings, NamedAnalyzer analyzer, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo) {
        super(names, precisionStep, boost, fieldType, docValues, nullValue, ignoreMalformed, coerce, postingsProvider, docValuesProvider, similarity, normsLoading, fieldDataSettings, indexSettings, multiFields, copyTo);
        this.analyzer = analyzer;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        StringFieldMapper.ValueAndBoost valueAndBoost = StringFieldMapper.parseCreateFieldForString(context, null, this.boost);
        if (valueAndBoost.value() == null && this.nullValue() == null) {
            return;
        }
        if (this.fieldType.indexed() || this.fieldType.stored() || this.hasDocValues()) {
            int count = valueAndBoost.value() == null ? this.nullValue() : TokenCountFieldMapper.countPositions(this.analyzer.analyzer().tokenStream(this.name(), valueAndBoost.value()));
            this.addIntegerFields(context, fields, count, valueAndBoost.boost());
        }
        if (fields.isEmpty()) {
            context.ignoredValue(this.names.indexName(), valueAndBoost.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int countPositions(TokenStream tokenStream) throws IOException {
        try {
            int count = 0;
            PositionIncrementAttribute position = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                count += position.getPositionIncrement();
            }
            tokenStream.end();
            int n = count += position.getPositionIncrement();
            return n;
        }
        finally {
            tokenStream.close();
        }
    }

    public String analyzer() {
        return this.analyzer.name();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.analyzer = ((TokenCountFieldMapper)mergeWith).analyzer;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        builder.field("analyzer", this.analyzer());
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.tokenCountField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(XContentMapValues.nodeIntegerValue(propNode));
                    continue;
                }
                if (!propName.equals("analyzer")) continue;
                NamedAnalyzer analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.analyzer(analyzer);
            }
            if (builder.analyzer() == null) {
                throw new MapperParsingException("Analyzer must be set for field [" + name + "] but wasn't.");
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, TokenCountFieldMapper> {
        private Integer nullValue = Defaults.NULL_VALUE;
        private NamedAnalyzer analyzer;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE), 8);
            this.builder = this;
        }

        public Builder nullValue(int nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder analyzer(NamedAnalyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public NamedAnalyzer analyzer() {
            return this.analyzer;
        }

        @Override
        public TokenCountFieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.boost == 1.0f);
            TokenCountFieldMapper fieldMapper = new TokenCountFieldMapper(this.buildNames(context), this.fieldType.numericPrecisionStep(), this.boost, this.fieldType, this.docValues, this.nullValue, this.ignoreMalformed(context), this.coerce(context), this.postingsProvider, this.docValuesProvider, this.similarity, this.normsLoading, this.fieldDataSettings, context.indexSettings(), this.analyzer, this.multiFieldsBuilder.build(this, context), this.copyTo);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends IntegerFieldMapper.Defaults {
    }
}

