/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;

public class VersionFieldMapper
extends AbstractFieldMapper<Long>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_version";
    public static final String CONTENT_TYPE = "_version";
    private final ThreadLocal<Field> fieldCache = new ThreadLocal<Field>(){

        @Override
        protected Field initialValue() {
            return new NumericDocValuesField("_version", -1L);
        }
    };

    public VersionFieldMapper() {
        this(null);
    }

    VersionFieldMapper(DocValuesFormatProvider docValuesFormat) {
        super(new FieldMapper.Names("_version", "_version", "_version", "_version"), 1.0f, Defaults.FIELD_TYPE, null, null, null, null, docValuesFormat, null, null, null, ImmutableSettings.EMPTY);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        Field version = this.fieldCache.get();
        context.version(version);
        fields.add(version);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public Long value(Object value) {
        if (value == null || value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(value.toString());
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        for (int i = 1; i < context.docs().size(); ++i) {
            ParseContext.Document doc = context.docs().get(i);
            doc.add((IndexableField)new NumericDocValuesField("_version", 0L));
        }
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("long");
    }

    @Override
    protected String contentType() {
        return "_version";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && (this.docValuesFormat == null || this.docValuesFormat.name().equals(this.defaultDocValuesFormat()))) {
            return builder;
        }
        builder.startObject("_version");
        if (this.docValuesFormat != null) {
            if (includeDefaults || !this.docValuesFormat.name().equals(this.defaultDocValuesFormat())) {
                builder.field("doc_values_format", this.docValuesFormat.name());
            }
        } else {
            String format = this.defaultDocValuesFormat();
            if (format == null) {
                format = "default";
            }
            builder.field("doc_values_format", format);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (mergeContext.mergeFlags().simulate()) {
            return;
        }
        AbstractFieldMapper fieldMergeWith = (AbstractFieldMapper)mergeWith;
        if (fieldMergeWith.docValuesFormatProvider() != null) {
            this.docValuesFormat = fieldMergeWith.docValuesFormatProvider();
        }
    }

    @Override
    public void close() {
        this.fieldCache.remove();
    }

    @Override
    public boolean hasDocValues() {
        return true;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.version();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("doc_values_format")) continue;
                String docValuesFormatName = fieldNode.toString();
                builder.docValuesFormat(parserContext.docValuesFormatService().get(docValuesFormatName));
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, VersionFieldMapper> {
        DocValuesFormatProvider docValuesFormat;

        public Builder() {
            super("_version");
        }

        @Override
        public VersionFieldMapper build(Mapper.BuilderContext context) {
            return new VersionFieldMapper(this.docValuesFormat);
        }

        public Builder docValuesFormat(DocValuesFormatProvider docValuesFormat) {
            this.docValuesFormat = docValuesFormat;
            return this;
        }
    }

    public static class Defaults {
        public static final String NAME = "_version";
        public static final float BOOST = 1.0f;
        public static final FieldType FIELD_TYPE = NumericDocValuesField.TYPE;
    }
}

