/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.distributor.Distributor;

public final class DistributorDirectory
extends BaseDirectory {
    private final Distributor distributor;
    private final ConcurrentMap<String, Directory> nameDirMapping = ConcurrentCollections.newConcurrentMap();

    public DistributorDirectory(final Directory ... dirs) throws IOException {
        this(new Distributor(){
            final AtomicInteger count = new AtomicInteger();

            @Override
            public Directory primary() {
                return dirs[0];
            }

            @Override
            public Directory[] all() {
                return dirs;
            }

            @Override
            public synchronized Directory any() {
                return dirs[MathUtils.mod(this.count.incrementAndGet(), dirs.length)];
            }
        });
    }

    public DistributorDirectory(Distributor distributor) throws IOException {
        this.distributor = distributor;
        for (Directory dir : distributor.all()) {
            for (String file : dir.listAll()) {
                if (this.usePrimary(file)) continue;
                this.nameDirMapping.put(file, dir);
            }
        }
    }

    public final String[] listAll() throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        for (Directory dir : this.distributor.all()) {
            for (String file : dir.listAll()) {
                files.add(file);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public boolean fileExists(String name) throws IOException {
        try {
            return this.getDirectory(name).fileExists(name);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public void deleteFile(String name) throws IOException {
        this.getDirectory(name, true, true).deleteFile(name);
        Directory remove = (Directory)this.nameDirMapping.remove(name);
        assert (this.usePrimary(name) || remove != null) : "Tried to delete file " + name + " but couldn't";
    }

    public long fileLength(String name) throws IOException {
        return this.getDirectory(name).fileLength(name);
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.getDirectory(name, false, false).createOutput(name, context);
    }

    public void sync(Collection<String> names) throws IOException {
        for (Directory dir : this.distributor.all()) {
            dir.sync(names);
        }
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        return this.getDirectory(name).openInput(name, context);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])this.distributor.all());
    }

    private Directory getDirectory(String name) throws IOException {
        return this.getDirectory(name, true, false);
    }

    private boolean usePrimary(String name) {
        return "segments.gen".equals(name) || Store.isChecksum(name);
    }

    private Directory getDirectory(String name, boolean failIfNotAssociated, boolean iterate) throws IOException {
        Directory dir;
        Directory directory;
        if (this.usePrimary(name)) {
            return this.distributor.primary();
        }
        if (!this.nameDirMapping.containsKey(name)) {
            if (iterate) {
                for (Directory dir2 : this.distributor.all()) {
                    if (!dir2.fileExists(name)) continue;
                    Directory directory2 = this.nameDirMapping.putIfAbsent(name, dir2);
                    return directory2 == null ? dir2 : directory2;
                }
            }
            if (failIfNotAssociated) {
                throw new FileNotFoundException("No such file [" + name + "]");
            }
        }
        return (directory = this.nameDirMapping.putIfAbsent(name, dir = this.distributor.any())) == null ? dir : directory;
    }

    public Lock makeLock(String name) {
        return this.distributor.primary().makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        this.distributor.primary().clearLock(name);
    }

    public LockFactory getLockFactory() {
        return this.distributor.primary().getLockFactory();
    }

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.distributor.primary().setLockFactory(lockFactory);
    }

    public String getLockID() {
        return this.distributor.primary().getLockID();
    }

    public String toString() {
        return this.distributor.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(DirectoryService directoryService, String from, String to) throws IOException {
        Directory directory = this.getDirectory(from);
        if (this.nameDirMapping.putIfAbsent(to, directory) != null) {
            throw new IOException("Can't rename file from " + from + " to: " + to + "target file already exists");
        }
        boolean success = false;
        try {
            directoryService.renameFile(directory, from, to);
            this.nameDirMapping.remove(from);
            success = true;
        }
        finally {
            if (!success) {
                this.nameDirMapping.remove(to);
            }
        }
    }
}

