/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.reroute;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.AcknowledgedRestListener;

public class RestClusterRerouteAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestClusterRerouteAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        this.settingsFilter = settingsFilter;
        controller.registerHandler(RestRequest.Method.POST, "/_cluster/reroute", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) throws Exception {
        final ClusterRerouteRequest clusterRerouteRequest = Requests.clusterRerouteRequest();
        clusterRerouteRequest.listenerThreaded(false);
        clusterRerouteRequest.dryRun(request.paramAsBoolean("dry_run", clusterRerouteRequest.dryRun()));
        clusterRerouteRequest.explain(request.paramAsBoolean("explain", clusterRerouteRequest.explain()));
        clusterRerouteRequest.timeout(request.paramAsTime("timeout", clusterRerouteRequest.timeout()));
        clusterRerouteRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterRerouteRequest.masterNodeTimeout()));
        if (request.hasContent()) {
            clusterRerouteRequest.source(request.content());
        }
        client.admin().cluster().reroute(clusterRerouteRequest, (ActionListener<ClusterRerouteResponse>)new AcknowledgedRestListener<ClusterRerouteResponse>(channel){

            @Override
            protected void addCustomFields(XContentBuilder builder, ClusterRerouteResponse response) throws IOException {
                builder.startObject("state");
                if (request.param("filter_metadata") == null) {
                    request.params().put("filter_metadata", "true");
                }
                response.getState().settingsFilter(RestClusterRerouteAction.this.settingsFilter).toXContent(builder, request);
                builder.endObject();
                if (clusterRerouteRequest.explain()) {
                    assert (response.getExplanations() != null);
                    response.getExplanations().toXContent(builder, ToXContent.EMPTY_PARAMS);
                }
            }
        });
    }
}

