/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.date;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.date.InternalDateRange;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public class DateRangeParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return InternalDateRange.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceParser<ValuesSource.Numeric> vsParser = ValuesSourceParser.numeric(aggregationName, InternalDateRange.TYPE, context).targetValueType(ValueType.DATE).requiresSortedValues(true).formattable(true).build();
        ArrayList<RangeAggregator.Range> ranges = null;
        boolean keyed = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"ranges".equals(currentFieldName)) continue;
                ranges = new ArrayList<RangeAggregator.Range>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    double from = Double.NEGATIVE_INFINITY;
                    String fromAsStr = null;
                    double to = Double.POSITIVE_INFINITY;
                    String toAsStr = null;
                    String key = null;
                    String toOrFromOrKey = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            toOrFromOrKey = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            if ("from".equals(toOrFromOrKey)) {
                                from = parser.doubleValue();
                                continue;
                            }
                            if ("to".equals(toOrFromOrKey)) {
                                to = parser.doubleValue();
                                continue;
                            }
                            throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
                        }
                        if (token != XContentParser.Token.VALUE_STRING) continue;
                        if ("from".equals(toOrFromOrKey)) {
                            fromAsStr = parser.text();
                            continue;
                        }
                        if ("to".equals(toOrFromOrKey)) {
                            toAsStr = parser.text();
                            continue;
                        }
                        if ("key".equals(toOrFromOrKey)) {
                            key = parser.text();
                            continue;
                        }
                        throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
                    }
                    ranges.add(new RangeAggregator.Range(key, from, fromAsStr, to, toAsStr));
                }
                continue;
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("keyed".equals(currentFieldName)) {
                    keyed = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (ranges == null) {
            throw new SearchParseException(context, "Missing [ranges] in ranges aggregator [" + aggregationName + "]");
        }
        return new RangeAggregator.Factory(aggregationName, vsParser.config(), InternalDateRange.FACTORY, ranges, keyed);
    }
}

