/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.geobounds;

import java.io.IOException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.geobounds.GeoBounds;

public class InternalGeoBounds
extends InternalMetricsAggregation
implements GeoBounds {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("geo_bounds");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalGeoBounds readResult(StreamInput in) throws IOException {
            InternalGeoBounds result = new InternalGeoBounds();
            result.readFrom(in);
            return result;
        }
    };
    private double top;
    private double bottom;
    private double posLeft;
    private double posRight;
    private double negLeft;
    private double negRight;
    private boolean wrapLongitude;

    InternalGeoBounds() {
    }

    InternalGeoBounds(String name, double top, double bottom, double posLeft, double posRight, double negLeft, double negRight, boolean wrapLongitude) {
        super(name);
        this.top = top;
        this.bottom = bottom;
        this.posLeft = posLeft;
        this.posRight = posRight;
        this.negLeft = negLeft;
        this.negRight = negRight;
        this.wrapLongitude = wrapLongitude;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        double top = Double.NEGATIVE_INFINITY;
        double bottom = Double.POSITIVE_INFINITY;
        double posLeft = Double.POSITIVE_INFINITY;
        double posRight = Double.NEGATIVE_INFINITY;
        double negLeft = Double.POSITIVE_INFINITY;
        double negRight = Double.NEGATIVE_INFINITY;
        for (InternalAggregation aggregation : reduceContext.aggregations()) {
            InternalGeoBounds bounds = (InternalGeoBounds)aggregation;
            if (bounds.top > top) {
                top = bounds.top;
            }
            if (bounds.bottom < bottom) {
                bottom = bounds.bottom;
            }
            if (bounds.posLeft < posLeft) {
                posLeft = bounds.posLeft;
            }
            if (bounds.posRight > posRight) {
                posRight = bounds.posRight;
            }
            if (bounds.negLeft < negLeft) {
                negLeft = bounds.negLeft;
            }
            if (!(bounds.negRight > negRight)) continue;
            negRight = bounds.negRight;
        }
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        GeoPoint topLeft = this.topLeft();
        GeoPoint bottomRight = this.bottomRight();
        if (topLeft != null) {
            builder.startObject("bounds");
            builder.startObject("top_left");
            builder.field("lat", topLeft.lat());
            builder.field("lon", topLeft.lon());
            builder.endObject();
            builder.startObject("bottom_right");
            builder.field("lat", bottomRight.lat());
            builder.field("lon", bottomRight.lon());
            builder.endObject();
            builder.endObject();
        }
        return builder.endObject();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.top = in.readDouble();
        this.bottom = in.readDouble();
        this.posLeft = in.readDouble();
        this.posRight = in.readDouble();
        this.negLeft = in.readDouble();
        this.negRight = in.readDouble();
        this.wrapLongitude = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeDouble(this.top);
        out.writeDouble(this.bottom);
        out.writeDouble(this.posLeft);
        out.writeDouble(this.posRight);
        out.writeDouble(this.negLeft);
        out.writeDouble(this.negRight);
        out.writeBoolean(this.wrapLongitude);
    }

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    private BoundingBox resolveBoundingBox() {
        if (Double.isInfinite(this.top)) {
            return null;
        }
        if (Double.isInfinite(this.posLeft)) {
            return new BoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.negRight));
        }
        if (Double.isInfinite(this.negLeft)) {
            return new BoundingBox(new GeoPoint(this.top, this.posLeft), new GeoPoint(this.bottom, this.posRight));
        }
        if (this.wrapLongitude) {
            double unwrappedWidth = this.posRight - this.negLeft;
            double wrappedWidth = 180.0 - this.posLeft - (-180.0 - this.negRight);
            if (unwrappedWidth <= wrappedWidth) {
                return new BoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.posRight));
            }
            return new BoundingBox(new GeoPoint(this.top, this.posLeft), new GeoPoint(this.bottom, this.negRight));
        }
        return new BoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.posRight));
    }

    @Override
    public GeoPoint topLeft() {
        BoundingBox boundingBox = this.resolveBoundingBox();
        if (boundingBox == null) {
            return null;
        }
        return boundingBox.topLeft();
    }

    @Override
    public GeoPoint bottomRight() {
        BoundingBox boundingBox = this.resolveBoundingBox();
        if (boundingBox == null) {
            return null;
        }
        return boundingBox.bottomRight();
    }

    private static class BoundingBox {
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        public BoundingBox(GeoPoint topLeft, GeoPoint bottomRight) {
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        public GeoPoint topLeft() {
            return this.topLeft;
        }

        public GeoPoint bottomRight() {
            return this.bottomRight;
        }
    }
}

