/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.facet.FacetPhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.FilterBinaryParseElement;
import org.elasticsearch.search.query.FromParseElement;
import org.elasticsearch.search.query.IndicesBoostParseElement;
import org.elasticsearch.search.query.MinScoreParseElement;
import org.elasticsearch.search.query.PostFilterParseElement;
import org.elasticsearch.search.query.QueryBinaryParseElement;
import org.elasticsearch.search.query.QueryParseElement;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.SizeParseElement;
import org.elasticsearch.search.query.TimeoutParseElement;
import org.elasticsearch.search.rescore.RescorePhase;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.sort.SortParseElement;
import org.elasticsearch.search.sort.TrackScoresParseElement;
import org.elasticsearch.search.suggest.SuggestPhase;

public class QueryPhase
implements SearchPhase {
    private final FacetPhase facetPhase;
    private final AggregationPhase aggregationPhase;
    private final SuggestPhase suggestPhase;
    private RescorePhase rescorePhase;

    @Inject
    public QueryPhase(FacetPhase facetPhase, AggregationPhase aggregationPhase, SuggestPhase suggestPhase, RescorePhase rescorePhase) {
        this.facetPhase = facetPhase;
        this.aggregationPhase = aggregationPhase;
        this.suggestPhase = suggestPhase;
        this.rescorePhase = rescorePhase;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, FromParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("from", new FromParseElement()).put("size", (FromParseElement)((Object)new SizeParseElement())).put("indices_boost", (FromParseElement)((Object)new IndicesBoostParseElement())).put("indicesBoost", (FromParseElement)((Object)new IndicesBoostParseElement())).put("query", (FromParseElement)((Object)new QueryParseElement())).put("queryBinary", (FromParseElement)((Object)new QueryBinaryParseElement())).put("query_binary", (FromParseElement)((Object)new QueryBinaryParseElement())).put("filter", (FromParseElement)((Object)new PostFilterParseElement())).put("post_filter", (FromParseElement)((Object)new PostFilterParseElement())).put("postFilter", (FromParseElement)((Object)new PostFilterParseElement())).put("filterBinary", (FromParseElement)((Object)new FilterBinaryParseElement())).put("filter_binary", (FromParseElement)((Object)new FilterBinaryParseElement())).put("sort", (FromParseElement)((Object)new SortParseElement())).put("trackScores", (FromParseElement)((Object)new TrackScoresParseElement())).put("track_scores", (FromParseElement)((Object)new TrackScoresParseElement())).put("min_score", (FromParseElement)((Object)new MinScoreParseElement())).put("minScore", (FromParseElement)((Object)new MinScoreParseElement())).put("timeout", (FromParseElement)((Object)new TimeoutParseElement())).putAll(this.facetPhase.parseElements()).putAll(this.aggregationPhase.parseElements()).putAll(this.suggestPhase.parseElements()).putAll(this.rescorePhase.parseElements());
        return parseElements.build();
    }

    @Override
    public void preProcess(SearchContext context) {
        context.preProcess();
    }

    @Override
    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        this.facetPhase.preProcess(searchContext);
        this.aggregationPhase.preProcess(searchContext);
        searchContext.queryResult().searchTimedOut(false);
        searchContext.searcher().inStage(ContextIndexSearcher.Stage.MAIN_QUERY);
        boolean rescore = false;
        try {
            TopDocs topDocs;
            searchContext.queryResult().from(searchContext.from());
            searchContext.queryResult().size(searchContext.size());
            Query query = searchContext.query();
            int numDocs = searchContext.from() + searchContext.size();
            if (searchContext.searchType() == SearchType.COUNT || numDocs == 0) {
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searchContext.searcher().search(query, (Collector)collector);
                topDocs = new TopDocs(collector.getTotalHits(), Lucene.EMPTY_SCORE_DOCS, 0.0f);
            } else if (searchContext.searchType() == SearchType.SCAN) {
                topDocs = searchContext.scanContext().execute(searchContext);
            } else if (!searchContext.useSlowScroll() && searchContext.request().scroll() != null) {
                numDocs = searchContext.size();
                ScoreDoc lastEmittedDoc = searchContext.lastEmittedDoc();
                if (searchContext.sort() != null) {
                    topDocs = searchContext.searcher().searchAfter(lastEmittedDoc, query, null, numDocs, searchContext.sort(), searchContext.trackScores(), searchContext.trackScores());
                } else {
                    rescore = !searchContext.rescore().isEmpty();
                    for (RescoreSearchContext rescoreContext : searchContext.rescore()) {
                        numDocs = Math.max(rescoreContext.window(), numDocs);
                    }
                    topDocs = searchContext.searcher().searchAfter(lastEmittedDoc, query, numDocs);
                }
                int size = topDocs.scoreDocs.length;
                if (size > 0 && (searchContext.searchType() == SearchType.QUERY_AND_FETCH || searchContext.searchType() == SearchType.DFS_QUERY_AND_FETCH)) {
                    searchContext.lastEmittedDoc(topDocs.scoreDocs[size - 1]);
                }
            } else if (searchContext.sort() != null) {
                topDocs = searchContext.searcher().search(query, null, numDocs, searchContext.sort(), searchContext.trackScores(), searchContext.trackScores());
            } else {
                rescore = !searchContext.rescore().isEmpty();
                for (RescoreSearchContext rescoreContext : searchContext.rescore()) {
                    numDocs = Math.max(rescoreContext.window(), numDocs);
                }
                topDocs = searchContext.searcher().search(query, numDocs);
            }
            searchContext.queryResult().topDocs(topDocs);
        }
        catch (Throwable e) {
            throw new QueryPhaseExecutionException(searchContext, "Failed to execute main query", e);
        }
        finally {
            searchContext.searcher().finishStage(ContextIndexSearcher.Stage.MAIN_QUERY);
        }
        if (rescore) {
            this.rescorePhase.execute(searchContext);
        }
        this.suggestPhase.execute(searchContext);
        this.facetPhase.execute(searchContext);
        this.aggregationPhase.execute(searchContext);
    }
}

