/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cluster.routing.operation.plain.Preference;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.search.suggest.DirectSpellcheckerSettings;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.phrase.WordScorer;

class PhraseSuggestionContext
extends SuggestionSearchContext.SuggestionContext {
    private final BytesRef SEPARATOR = new BytesRef((CharSequence)" ");
    private float maxErrors = 0.5f;
    private BytesRef separator = this.SEPARATOR;
    private float realworldErrorLikelihood = 0.95f;
    private List<DirectCandidateGenerator> generators = new ArrayList<DirectCandidateGenerator>();
    private int gramSize = 1;
    private float confidence = 1.0f;
    private int tokenLimit = 10;
    private BytesRef preTag;
    private BytesRef postTag;
    private CompiledScript collateQueryScript;
    private CompiledScript collateFilterScript;
    private String preference = Preference.ONLY_LOCAL.type();
    private Map<String, Object> collateScriptParams = new HashMap<String, Object>(1);
    private WordScorer.WordScorerFactory scorer;
    private boolean requireUnigram = true;

    public PhraseSuggestionContext(Suggester<? extends PhraseSuggestionContext> suggester) {
        super(suggester);
    }

    public float maxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(Float maxErrors) {
        this.maxErrors = maxErrors.floatValue();
    }

    public BytesRef separator() {
        return this.separator;
    }

    public void setSeparator(BytesRef separator) {
        this.separator = separator;
    }

    public Float realworldErrorLikelyhood() {
        return Float.valueOf(this.realworldErrorLikelihood);
    }

    public void setRealWordErrorLikelihood(Float realworldErrorLikelihood) {
        this.realworldErrorLikelihood = realworldErrorLikelihood.floatValue();
    }

    public void addGenerator(DirectCandidateGenerator generator) {
        this.generators.add(generator);
    }

    public List<DirectCandidateGenerator> generators() {
        return this.generators;
    }

    public void setGramSize(int gramSize) {
        this.gramSize = gramSize;
    }

    public int gramSize() {
        return this.gramSize;
    }

    public float confidence() {
        return this.confidence;
    }

    public void setConfidence(float confidence) {
        this.confidence = confidence;
    }

    public void setModel(WordScorer.WordScorerFactory scorer) {
        this.scorer = scorer;
    }

    public WordScorer.WordScorerFactory model() {
        return this.scorer;
    }

    public void setRequireUnigram(boolean requireUnigram) {
        this.requireUnigram = requireUnigram;
    }

    public boolean getRequireUnigram() {
        return this.requireUnigram;
    }

    public void setTokenLimit(int tokenLimit) {
        this.tokenLimit = tokenLimit;
    }

    public int getTokenLimit() {
        return this.tokenLimit;
    }

    public void setPreTag(BytesRef preTag) {
        this.preTag = preTag;
    }

    public BytesRef getPreTag() {
        return this.preTag;
    }

    public void setPostTag(BytesRef postTag) {
        this.postTag = postTag;
    }

    public BytesRef getPostTag() {
        return this.postTag;
    }

    CompiledScript getCollateQueryScript() {
        return this.collateQueryScript;
    }

    void setCollateQueryScript(CompiledScript collateQueryScript) {
        this.collateQueryScript = collateQueryScript;
    }

    CompiledScript getCollateFilterScript() {
        return this.collateFilterScript;
    }

    void setCollateFilterScript(CompiledScript collateFilterScript) {
        this.collateFilterScript = collateFilterScript;
    }

    String getPreference() {
        return this.preference;
    }

    void setPreference(String preference) {
        this.preference = preference;
    }

    Map<String, Object> getCollateScriptParams() {
        return this.collateScriptParams;
    }

    void setCollateScriptParams(Map<String, Object> collateScriptParams) {
        this.collateScriptParams = collateScriptParams;
    }

    static class DirectCandidateGenerator
    extends DirectSpellcheckerSettings {
        private Analyzer preFilter;
        private Analyzer postFilter;
        private String field;
        private int size = 5;

        DirectCandidateGenerator() {
        }

        public String field() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public int size() {
            return this.size;
        }

        public void size(int size) {
            if (size <= 0) {
                throw new ElasticsearchIllegalArgumentException("Size must be positive");
            }
            this.size = size;
        }

        public Analyzer preFilter() {
            return this.preFilter;
        }

        public void preFilter(Analyzer preFilter) {
            this.preFilter = preFilter;
        }

        public Analyzer postFilter() {
            return this.postFilter;
        }

        public void postFilter(Analyzer postFilter) {
            this.postFilter = postFilter;
        }
    }
}

