/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.unit.TimeValue;

public class TransportRequestOptions {
    public static final TransportRequestOptions EMPTY = TransportRequestOptions.options();
    private TimeValue timeout;
    private boolean compress;
    private Type type = Type.REG;

    public static TransportRequestOptions options() {
        return new TransportRequestOptions();
    }

    public TransportRequestOptions withTimeout(long timeout) {
        return this.withTimeout(TimeValue.timeValueMillis(timeout));
    }

    public TransportRequestOptions withTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public TransportRequestOptions withCompress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public TransportRequestOptions withType(Type type) {
        this.type = type;
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public boolean compress() {
        return this.compress;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        RECOVERY,
        BULK,
        REG,
        STATE,
        PING;


        public static Type fromString(String type) {
            if ("bulk".equalsIgnoreCase(type)) {
                return BULK;
            }
            if ("reg".equalsIgnoreCase(type)) {
                return REG;
            }
            if ("state".equalsIgnoreCase(type)) {
                return STATE;
            }
            if ("recovery".equalsIgnoreCase(type)) {
                return RECOVERY;
            }
            if ("ping".equalsIgnoreCase(type)) {
                return PING;
            }
            throw new ElasticsearchIllegalArgumentException("failed to match transport type for [" + type + "]");
        }
    }
}

