/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DtoReader {
    public static final Function<ConfigurationItem, ConfigurationItemId> ciToCiId = new Function<ConfigurationItem, ConfigurationItemId>(){

        public ConfigurationItemId apply(ConfigurationItem input) {
            return new ConfigurationItemId(input.getId(), input.getType());
        }
    };
    public static final Function<ConfigurationItemData, ConfigurationItemId> ciDataToCiId = new Function<ConfigurationItemData, ConfigurationItemId>(){

        public ConfigurationItemId apply(ConfigurationItemData input) {
            return new ConfigurationItemId(input.getId(), input.getType());
        }
    };
    public static final Function<ConfigurationItemId, ConfigurationItemData> ciIdToCiData = new Function<ConfigurationItemId, ConfigurationItemData>(){

        public ConfigurationItemData apply(ConfigurationItemId input) {
            return new ConfigurationItemData(input.getId(), input.getType());
        }
    };

    public List<com.xebialabs.deployit.security.Role> readRoleAssignments(List<RolePrincipals> assignments) {
        ArrayList roles = Lists.newArrayList();
        for (RolePrincipals roleAssignment : assignments) {
            Role roleDto = roleAssignment.getRole();
            com.xebialabs.deployit.security.Role role = DtoReader.asRole(roleDto);
            List principals = roleAssignment.getPrincipals();
            role.getPrincipalsAssigned().addAll(principals);
            roles.add(role);
        }
        return roles;
    }

    private static com.xebialabs.deployit.security.Role asRole(Role roleDto) {
        return new com.xebialabs.deployit.security.Role(roleDto.getId(), roleDto.getName());
    }

    public Multimap<com.xebialabs.deployit.security.Role, Permission> readRolePermissions(List<RolePermissions> permissions, List<com.xebialabs.deployit.security.Role> roles) {
        HashMultimap multimap = HashMultimap.create();
        for (RolePermissions rolePermission : permissions) {
            com.xebialabs.deployit.security.Role role = DtoReader.asRole(rolePermission.getRole());
            if (role.getId() == null) {
                role = DtoReader.findRole(role.getName(), roles);
            }
            List permissionList = Lists.transform((List)rolePermission.getPermissions(), (Function)new Function<String, Permission>(){

                public Permission apply(String input) {
                    return Permission.find((String)input);
                }
            });
            multimap.putAll((Object)role, (Iterable)permissionList);
        }
        return multimap;
    }

    private static com.xebialabs.deployit.security.Role findRole(String name, List<com.xebialabs.deployit.security.Role> roles) {
        for (com.xebialabs.deployit.security.Role role : roles) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        throw new IllegalArgumentException(String.format("Couldn't find role with name [%s]", name));
    }
}

