/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.io.TemporaryFiles;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.security.Permissions;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Provider
@Component
@ServerInterceptor
public class OpenJcrSessionDuringRequestInterceptor
implements PreProcessInterceptor,
PostProcessInterceptor {
    public static final String MDC_KEY_USERNAME = "username";
    private static final Logger logger = LoggerFactory.getLogger(OpenJcrSessionDuringRequestInterceptor.class);

    public void postProcess(ServerResponse response) {
        logger.trace("Logging out...");
        JcrTemplateHolder.get().logout();
        NodeReaderContext.get().release();
        TemporaryFiles.clear();
        WorkdirHolder.clear();
        MDC.remove((String)MDC_KEY_USERNAME);
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
        Authentication authentication;
        JcrTemplateHolder.get().login();
        NodeReaderContext.get().hold();
        if (method.getResourceClass().isAnnotationPresent(Workdir.class)) {
            WorkdirHolder.initWorkdir();
        }
        if ((authentication = Permissions.getAuthentication()) != null) {
            MDC.put((String)MDC_KEY_USERNAME, (String)authentication.getName());
        }
        return null;
    }
}

