/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions.js;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.js.JavascriptLexer;
import org.apache.lucene.expressions.js.JavascriptParser;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.util.IOUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class JavascriptCompiler {
    private static final int CLASSFILE_VERSION = 51;
    private static final String COMPILED_EXPRESSION_CLASS = JavascriptCompiler.class.getName() + "$CompiledExpression";
    private static final String COMPILED_EXPRESSION_INTERNAL = COMPILED_EXPRESSION_CLASS.replace('.', '/');
    private static final Type EXPRESSION_TYPE = Type.getType(Expression.class);
    private static final Type FUNCTION_VALUES_TYPE = Type.getType(FunctionValues.class);
    private static final Method EXPRESSION_CTOR = JavascriptCompiler.getMethod("void <init>(String, String[])");
    private static final Method EVALUATE_METHOD = JavascriptCompiler.getMethod("double evaluate(int, " + FunctionValues.class.getName() + "[])");
    private static final Method DOUBLE_VAL_METHOD = JavascriptCompiler.getMethod("double doubleVal(int)");
    private static final int MAX_SOURCE_LENGTH = 16384;
    private final String sourceText;
    private final Map<String, Integer> externalsMap = new LinkedHashMap<String, Integer>();
    private final ClassWriter classWriter = new ClassWriter(3);
    private GeneratorAdapter gen;
    private final Map<String, java.lang.reflect.Method> functions;
    public static final Map<String, java.lang.reflect.Method> DEFAULT_FUNCTIONS;

    private static Method getMethod(String method) {
        return Method.getMethod((String)method);
    }

    public static Expression compile(String sourceText) throws ParseException {
        return new JavascriptCompiler(sourceText).compileExpression(JavascriptCompiler.class.getClassLoader());
    }

    public static Expression compile(String sourceText, Map<String, java.lang.reflect.Method> functions, ClassLoader parent) throws ParseException {
        if (parent == null) {
            throw new NullPointerException("A parent ClassLoader must be given.");
        }
        for (java.lang.reflect.Method m : functions.values()) {
            JavascriptCompiler.checkFunction(m, parent);
        }
        return new JavascriptCompiler(sourceText, functions).compileExpression(parent);
    }

    private static void unusedTestCompile() {
        Object f = null;
        double ret = f.doubleVal(2);
    }

    private JavascriptCompiler(String sourceText) {
        this(sourceText, DEFAULT_FUNCTIONS);
    }

    private JavascriptCompiler(String sourceText, Map<String, java.lang.reflect.Method> functions) {
        if (sourceText == null) {
            throw new NullPointerException();
        }
        this.sourceText = sourceText;
        this.functions = functions;
    }

    private Expression compileExpression(ClassLoader parent) throws ParseException {
        try {
            Tree antlrTree = this.getAntlrComputedExpressionTree();
            this.beginCompile();
            this.recursiveCompile(antlrTree, Type.DOUBLE_TYPE);
            this.endCompile();
            Class<? extends Expression> evaluatorClass = new Loader(parent).define(COMPILED_EXPRESSION_CLASS, this.classWriter.toByteArray());
            Constructor<? extends Expression> constructor = evaluatorClass.getConstructor(String.class, String[].class);
            return constructor.newInstance(this.sourceText, this.externalsMap.keySet().toArray(new String[this.externalsMap.size()]));
        }
        catch (InstantiationException exception) {
            throw new IllegalStateException("An internal error occurred attempting to compile the expression (" + this.sourceText + ").", exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("An internal error occurred attempting to compile the expression (" + this.sourceText + ").", exception);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("An internal error occurred attempting to compile the expression (" + this.sourceText + ").", exception);
        }
        catch (InvocationTargetException exception) {
            throw new IllegalStateException("An internal error occurred attempting to compile the expression (" + this.sourceText + ").", exception);
        }
    }

    private void beginCompile() {
        this.classWriter.visit(51, 4145, COMPILED_EXPRESSION_INTERNAL, null, EXPRESSION_TYPE.getInternalName(), null);
        String clippedSourceText = this.sourceText.length() <= 16384 ? this.sourceText : this.sourceText.substring(0, 16381) + "...";
        this.classWriter.visitSource(clippedSourceText, null);
        GeneratorAdapter constructor = new GeneratorAdapter(4097, EXPRESSION_CTOR, null, null, (ClassVisitor)this.classWriter);
        constructor.loadThis();
        constructor.loadArgs();
        constructor.invokeConstructor(EXPRESSION_TYPE, EXPRESSION_CTOR);
        constructor.returnValue();
        constructor.endMethod();
        this.gen = new GeneratorAdapter(4097, EVALUATE_METHOD, null, null, (ClassVisitor)this.classWriter);
    }

    private void recursiveCompile(Tree current, Type expected) {
        int type = current.getType();
        String text = current.getText();
        switch (type) {
            case 15: {
                Tree identifier = current.getChild(0);
                String call = identifier.getText();
                int arguments = current.getChildCount() - 1;
                java.lang.reflect.Method method = this.functions.get(call);
                if (method == null) {
                    throw new IllegalArgumentException("Unrecognized method call (" + call + ").");
                }
                int arity = method.getParameterTypes().length;
                if (arguments != arity) {
                    throw new IllegalArgumentException("Expected (" + arity + ") arguments for method call (" + call + "), but found (" + arguments + ").");
                }
                for (int argument = 1; argument <= arguments; ++argument) {
                    this.recursiveCompile(current.getChild(argument), Type.DOUBLE_TYPE);
                }
                this.gen.invokeStatic(Type.getType(method.getDeclaringClass()), Method.getMethod((java.lang.reflect.Method)method));
                this.gen.cast(Type.DOUBLE_TYPE, expected);
                break;
            }
            case 40: {
                int index;
                if (this.externalsMap.containsKey(text)) {
                    index = this.externalsMap.get(text);
                } else {
                    index = this.externalsMap.size();
                    this.externalsMap.put(text, index);
                }
                this.gen.loadArg(1);
                this.gen.push(index);
                this.gen.arrayLoad(FUNCTION_VALUES_TYPE);
                this.gen.loadArg(0);
                this.gen.invokeVirtual(FUNCTION_VALUES_TYPE, DOUBLE_VAL_METHOD);
                this.gen.cast(Type.DOUBLE_TYPE, expected);
                break;
            }
            case 37: {
                this.pushLong(expected, Long.parseLong(text.substring(2), 16));
                break;
            }
            case 41: {
                this.pushLong(expected, Long.parseLong(text.substring(1), 8));
                break;
            }
            case 33: {
                this.gen.push(Double.parseDouble(text));
                this.gen.cast(Type.DOUBLE_TYPE, expected);
                break;
            }
            case 30: {
                this.recursiveCompile(current.getChild(0), Type.DOUBLE_TYPE);
                this.gen.visitInsn(119);
                this.gen.cast(Type.DOUBLE_TYPE, expected);
                break;
            }
            case 4: {
                this.pushArith(99, current, expected);
                break;
            }
            case 32: {
                this.pushArith(103, current, expected);
                break;
            }
            case 29: {
                this.pushArith(107, current, expected);
                break;
            }
            case 25: {
                this.pushArith(111, current, expected);
                break;
            }
            case 28: {
                this.pushArith(115, current, expected);
                break;
            }
            case 8: {
                this.pushShift(121, current, expected);
                break;
            }
            case 9: {
                this.pushShift(123, current, expected);
                break;
            }
            case 10: {
                this.pushShift(125, current, expected);
                break;
            }
            case 5: {
                this.pushBitwise(127, current, expected);
                break;
            }
            case 7: {
                this.pushBitwise(129, current, expected);
                break;
            }
            case 11: {
                this.pushBitwise(131, current, expected);
                break;
            }
            case 6: {
                this.recursiveCompile(current.getChild(0), Type.LONG_TYPE);
                this.gen.push(-1L);
                this.gen.visitInsn(131);
                this.gen.cast(Type.LONG_TYPE, expected);
                break;
            }
            case 18: {
                this.pushCond(153, current, expected);
                break;
            }
            case 23: {
                this.pushCond(154, current, expected);
                break;
            }
            case 21: {
                this.pushCond(155, current, expected);
                break;
            }
            case 19: {
                this.pushCond(157, current, expected);
                break;
            }
            case 22: {
                this.pushCond(158, current, expected);
                break;
            }
            case 20: {
                this.pushCond(156, current, expected);
                break;
            }
            case 13: {
                Label labelNotTrue = new Label();
                Label labelNotReturn = new Label();
                this.recursiveCompile(current.getChild(0), Type.INT_TYPE);
                this.gen.visitJumpInsn(153, labelNotTrue);
                this.pushBoolean(expected, false);
                this.gen.goTo(labelNotReturn);
                this.gen.visitLabel(labelNotTrue);
                this.pushBoolean(expected, true);
                this.gen.visitLabel(labelNotReturn);
                break;
            }
            case 12: {
                Label andFalse = new Label();
                Label andEnd = new Label();
                this.recursiveCompile(current.getChild(0), Type.INT_TYPE);
                this.gen.visitJumpInsn(153, andFalse);
                this.recursiveCompile(current.getChild(1), Type.INT_TYPE);
                this.gen.visitJumpInsn(153, andFalse);
                this.pushBoolean(expected, true);
                this.gen.goTo(andEnd);
                this.gen.visitLabel(andFalse);
                this.pushBoolean(expected, false);
                this.gen.visitLabel(andEnd);
                break;
            }
            case 14: {
                Label orTrue = new Label();
                Label orEnd = new Label();
                this.recursiveCompile(current.getChild(0), Type.INT_TYPE);
                this.gen.visitJumpInsn(154, orTrue);
                this.recursiveCompile(current.getChild(1), Type.INT_TYPE);
                this.gen.visitJumpInsn(154, orTrue);
                this.pushBoolean(expected, false);
                this.gen.goTo(orEnd);
                this.gen.visitLabel(orTrue);
                this.pushBoolean(expected, true);
                this.gen.visitLabel(orEnd);
                break;
            }
            case 24: {
                Label condFalse = new Label();
                Label condEnd = new Label();
                this.recursiveCompile(current.getChild(0), Type.INT_TYPE);
                this.gen.visitJumpInsn(153, condFalse);
                this.recursiveCompile(current.getChild(1), expected);
                this.gen.goTo(condEnd);
                this.gen.visitLabel(condFalse);
                this.recursiveCompile(current.getChild(2), expected);
                this.gen.visitLabel(condEnd);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operation specified: (" + current.getText() + ").");
            }
        }
    }

    private void pushArith(int operator, Tree current, Type expected) {
        this.pushBinaryOp(operator, current, expected, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE);
    }

    private void pushShift(int operator, Tree current, Type expected) {
        this.pushBinaryOp(operator, current, expected, Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE);
    }

    private void pushBitwise(int operator, Tree current, Type expected) {
        this.pushBinaryOp(operator, current, expected, Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE);
    }

    private void pushBinaryOp(int operator, Tree current, Type expected, Type arg1, Type arg2, Type returnType) {
        this.recursiveCompile(current.getChild(0), arg1);
        this.recursiveCompile(current.getChild(1), arg2);
        this.gen.visitInsn(operator);
        this.gen.cast(returnType, expected);
    }

    private void pushCond(int operator, Tree current, Type expected) {
        Label labelTrue = new Label();
        Label labelReturn = new Label();
        this.recursiveCompile(current.getChild(0), Type.DOUBLE_TYPE);
        this.recursiveCompile(current.getChild(1), Type.DOUBLE_TYPE);
        this.gen.ifCmp(Type.DOUBLE_TYPE, operator, labelTrue);
        this.pushBoolean(expected, false);
        this.gen.goTo(labelReturn);
        this.gen.visitLabel(labelTrue);
        this.pushBoolean(expected, true);
        this.gen.visitLabel(labelReturn);
    }

    private void pushBoolean(Type expected, boolean truth) {
        switch (expected.getSort()) {
            case 5: {
                this.gen.push(truth);
                break;
            }
            case 7: {
                this.gen.push(truth ? 1L : 0L);
                break;
            }
            case 8: {
                this.gen.push(truth ? 1.0 : 0.0);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid expected type: " + expected);
            }
        }
    }

    private void pushLong(Type expected, long i) {
        switch (expected.getSort()) {
            case 5: {
                this.gen.push((int)i);
                break;
            }
            case 7: {
                this.gen.push(i);
                break;
            }
            case 8: {
                this.gen.push((double)i);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid expected type: " + expected);
            }
        }
    }

    private void endCompile() {
        this.gen.returnValue();
        this.gen.endMethod();
        this.classWriter.visitEnd();
    }

    private Tree getAntlrComputedExpressionTree() throws ParseException {
        ANTLRStringStream input = new ANTLRStringStream(this.sourceText);
        JavascriptLexer lexer = new JavascriptLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JavascriptParser parser = new JavascriptParser((TokenStream)tokens);
        try {
            return parser.expression().tree;
        }
        catch (RecognitionException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (RuntimeException exception) {
            if (exception.getCause() instanceof ParseException) {
                throw (ParseException)exception.getCause();
            }
            throw exception;
        }
    }

    private static void checkFunction(java.lang.reflect.Method method, ClassLoader parent) {
        ClassLoader functionClassloader = method.getDeclaringClass().getClassLoader();
        if (functionClassloader != null) {
            boolean found = false;
            while (parent != null) {
                if (parent == functionClassloader) {
                    found = true;
                    break;
                }
                parent = parent.getParent();
            }
            if (!found) {
                throw new IllegalArgumentException(method + " is not declared by a class which is accessible by the given parent ClassLoader.");
            }
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(method + " is not static.");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException(method + " is not public.");
        }
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            throw new IllegalArgumentException(method.getDeclaringClass().getName() + " is not public.");
        }
        for (Class<?> clazz : method.getParameterTypes()) {
            if (clazz.equals(Double.TYPE)) continue;
            throw new IllegalArgumentException(method + " must take only double parameters");
        }
        if (method.getReturnType() != Double.TYPE) {
            throw new IllegalArgumentException(method + " does not return a double.");
        }
    }

    static {
        HashMap<String, java.lang.reflect.Method> map = new HashMap<String, java.lang.reflect.Method>();
        try {
            Properties props = new Properties();
            try (Reader in = IOUtils.getDecodingReader(JavascriptCompiler.class, (String)(JavascriptCompiler.class.getSimpleName() + ".properties"), (Charset)StandardCharsets.UTF_8);){
                props.load(in);
            }
            for (String call : props.stringPropertyNames()) {
                String[] vals = props.getProperty(call).split(",");
                if (vals.length != 3) {
                    throw new Error("Syntax error while reading Javascript functions from resource");
                }
                Class<?> clazz = Class.forName(vals[0].trim());
                String methodName = vals[1].trim();
                int arity = Integer.parseInt(vals[2].trim());
                Object[] args = new Class[arity];
                Arrays.fill(args, Double.TYPE);
                java.lang.reflect.Method method = clazz.getMethod(methodName, (Class<?>[])args);
                JavascriptCompiler.checkFunction(method, JavascriptCompiler.class.getClassLoader());
                map.put(call, method);
            }
        }
        catch (IOException | ClassNotFoundException | NoSuchMethodException e) {
            throw new Error("Cannot resolve function", e);
        }
        DEFAULT_FUNCTIONS = Collections.unmodifiableMap(map);
    }

    static final class Loader
    extends ClassLoader {
        Loader(ClassLoader parent) {
            super(parent);
        }

        public Class<? extends Expression> define(String className, byte[] bytecode) {
            return this.defineClass(className, bytecode, 0, bytecode.length).asSubclass(Expression.class);
        }
    }
}

