/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractFirstPassGroupingCollector;
import org.apache.lucene.util.BytesRef;

public class TermFirstPassGroupingCollector
extends AbstractFirstPassGroupingCollector<BytesRef> {
    private SortedDocValues index;
    private String groupField;

    public TermFirstPassGroupingCollector(String groupField, Sort groupSort, int topNGroups) throws IOException {
        super(groupSort, topNGroups);
        this.groupField = groupField;
    }

    @Override
    protected BytesRef getDocGroupValue(int doc) {
        int ord = this.index.getOrd(doc);
        if (ord == -1) {
            return null;
        }
        return this.index.lookupOrd(ord);
    }

    @Override
    protected BytesRef copyDocGroupValue(BytesRef groupValue, BytesRef reuse) {
        if (groupValue == null) {
            return null;
        }
        if (reuse != null) {
            reuse.copyBytes(groupValue);
            return reuse;
        }
        return BytesRef.deepCopyOf((BytesRef)groupValue);
    }

    @Override
    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        super.setNextReader(readerContext);
        this.index = FieldCache.DEFAULT.getTermsIndex(readerContext.reader(), this.groupField);
    }
}

