/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.Tuple;
import java.util.List;

public class ChangeSet {
    private List<ConfigurationItem> createCis = Lists.newArrayList();
    private List<ConfigurationItem> updateCis = Lists.newArrayList();
    private List<String> deleteCiIds = Lists.newArrayList();
    private List<ConfigurationItem> createOrUpdateCis = Lists.newArrayList();
    private List<Tuple<String, String>> renameCis = Lists.newArrayList();
    private List<Tuple<String, String>> moveCis = Lists.newArrayList();
    private List<Tuple<String, String>> copyCis = Lists.newArrayList();
    private boolean disableVersionHistory = false;
    private List<ConfigurationItem> createOrUpdateActualUpdatedCis = Lists.newArrayList();
    private List<ConfigurationItem> createOrUpdateActualCreatedCis = Lists.newArrayList();

    public void create(ConfigurationItem ci) {
        this.createCis.add(ci);
    }

    public void create(List<? extends ConfigurationItem> entities) {
        this.createCis.addAll(entities);
    }

    public void update(ConfigurationItem ci) {
        this.updateCis.add(ci);
    }

    public void update(List<? extends ConfigurationItem> entities) {
        this.updateCis.addAll(entities);
    }

    public void createOrUpdate(ConfigurationItem entity) {
        this.createOrUpdateCis.add(entity);
    }

    public void createOrUpdate(List<? extends ConfigurationItem> entities) {
        this.createOrUpdateCis.addAll(entities);
    }

    public void delete(ConfigurationItem ci) {
        this.deleteCiIds.add(ci.getId());
    }

    public void delete(String id) {
        this.deleteCiIds.add(id);
    }

    public void delete(List<? extends String> ids) {
        this.deleteCiIds.addAll(ids);
    }

    public void rename(String id, String newName) {
        this.renameCis.add(Tuple.of(id, newName));
    }

    public void rename(ConfigurationItem ci, String newName) {
        this.renameCis.add(Tuple.of(ci.getId(), newName));
    }

    public void move(String ci, String newId) {
        this.moveCis.add(Tuple.of(ci, newId));
    }

    public void copy(String ci, String newId) {
        this.copyCis.add(Tuple.of(ci, newId));
    }

    public void setDisableVersionHistory(boolean checkPointRequested) {
        this.disableVersionHistory = checkPointRequested;
    }

    public List<ConfigurationItem> getCreateCis() {
        return this.createCis;
    }

    public List<ConfigurationItem> getUpdateCis() {
        return this.updateCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateCis() {
        return this.createOrUpdateCis;
    }

    public List<String> getDeleteCiIds() {
        return this.deleteCiIds;
    }

    public List<Tuple<String, String>> getRenameCis() {
        return this.renameCis;
    }

    public List<Tuple<String, String>> getMoveCis() {
        return this.moveCis;
    }

    public List<Tuple<String, String>> getCopyCis() {
        return this.copyCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualUpdatedCis() {
        return this.createOrUpdateActualUpdatedCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualCreatedCis() {
        return this.createOrUpdateActualCreatedCis;
    }

    public boolean isDisableVersionHistory() {
        return this.disableVersionHistory;
    }
}

