/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsJobScheduler {
    private static final Logger LOG = LoggerFactory.getLogger((String)JenkinsJobScheduler.class.getName());
    private URL jenkinsBaseUrl;

    public JenkinsJobScheduler(URL url) {
        this.jenkinsBaseUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleJenkinsJobWithParameters(String jobName, Map<String, Object> parameters) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.jenkinsBaseUrl.toString() + "/job/" + jobName + "/buildWithParameters").openConnection();
        try {
            byte[] data = JenkinsJobScheduler.makeContent(parameters).getBytes("UTF-8");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            connection.setRequestProperty("Content-Length", Integer.toString(data.length));
            try (OutputStream out = connection.getOutputStream();){
                out.write(data);
                out.flush();
            }
            int responseCode = connection.getResponseCode();
            LOG.info("Scheduled job: " + jobName + " with parameters: " + parameters.toString() + ", response code: " + responseCode);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String makeContent(Map<String, Object> parameters) {
        StringBuilder sb = new StringBuilder();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                sb.append(key);
                sb.append('=');
                sb.append(parameters.get(key));
                sb.append('&');
            }
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }
}

