/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingConcurrentModelController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOCache;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsCachingController
extends FsDecoratingConcurrentModelController<FsController<? extends FsConcurrentModel>> {
    private static final BitField<FsSyncOption> ABORT_CHANGES_OPTIONS = BitField.of(FsSyncOption.ABORT_CHANGES);
    private static final EntrySocketFactory ENTRY_SOCKET_FACTORY = JSE7.AVAILABLE ? EntrySocketFactory.NIO2 : EntrySocketFactory.OIO;
    private static final IOCache.Strategy STRATEGY = IOCache.Strategy.WRITE_BACK;
    private final IOPool<?> pool;
    private final Map<FsEntryName, EntryController> controllers = new HashMap<FsEntryName, EntryController>();

    public FsCachingController(FsController<? extends FsConcurrentModel> controller, IOPool<?> pool) {
        super(controller);
        if (null == pool) {
            throw new NullPointerException();
        }
        this.pool = pool;
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new Input(this.delegate.getInputSocket(name, options), name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return new Output(this.delegate.getOutputSocket(name, options, template), name, options, template);
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, Entry template) throws IOException {
        assert (this.isWriteLockedByCurrentThread());
        EntryController controller = this.controllers.get(name);
        if (null != controller) {
            this.delegate.mknod(name, type, options, template);
            this.controllers.remove(name);
            controller.clear();
        } else {
            this.delegate.mknod(name, type, options, template);
        }
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        assert (this.isWriteLockedByCurrentThread());
        if (name.isRoot()) {
            try {
                this.unlink0(name, options);
            }
            catch (FsFalsePositiveException ex) {
                try {
                    this.sync(ABORT_CHANGES_OPTIONS);
                }
                catch (IOException cannotHappen) {
                    throw new AssertionError((Object)cannotHappen);
                }
                throw ex;
            }
            this.sync(ABORT_CHANGES_OPTIONS);
        } else {
            this.unlink0(name, options);
        }
    }

    private void unlink0(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        EntryController controller = this.controllers.get(name);
        if (null != controller) {
            this.delegate.unlink(name, options);
            this.controllers.remove(name);
            controller.clear();
        } else {
            this.delegate.unlink(name, options);
        }
    }

    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.beforeSync(options, handler);
        this.delegate.sync(options, handler);
    }

    private <X extends IOException> void beforeSync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        assert (this.isWriteLockedByCurrentThread());
        if (0 >= this.controllers.size()) {
            return;
        }
        boolean flush = !options.get(FsSyncOption.ABORT_CHANGES);
        boolean clear = !flush || options.get(FsSyncOption.CLEAR_CACHE);
        Iterator<EntryController> i = this.controllers.values().iterator();
        while (i.hasNext()) {
            EntryController controller = i.next();
            try {
                if (!flush) continue;
                controller.flush();
            }
            catch (IOException ex) {
                throw (IOException)handler.fail(new FsSyncException((FsModel)this.getModel(), ex));
            }
            finally {
                try {
                    if (!clear) continue;
                    i.remove();
                    controller.clear();
                }
                catch (IOException ex) {
                    handler.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
                }
            }
        }
    }

    private final class EntryController {
        final FsEntryName name;
        final IOCache cache;
        @CheckForNull
        volatile InputSocket<?> input;
        @CheckForNull
        volatile OutputSocket<?> output;
        @Nullable
        volatile BitField<FsOutputOption> outputOptions;
        @CheckForNull
        volatile Entry template;

        EntryController(FsEntryName name) {
            this.name = name;
            this.cache = STRATEGY.newCache(FsCachingController.this.pool);
        }

        EntryController configure(BitField<FsInputOption> options) {
            options = options.clear(FsInputOption.CACHE);
            this.cache.configure(new EntryInput(FsCachingController.this.delegate.getInputSocket(this.name, options)));
            this.input = null;
            return this;
        }

        EntryController configure(BitField<FsOutputOption> options, @CheckForNull Entry template) {
            options = options.clear(FsOutputOption.CACHE);
            this.outputOptions = options;
            this.template = template;
            this.cache.configure(FsCachingController.this.delegate.getOutputSocket(this.name, options.clear(FsOutputOption.EXCLUSIVE), this.template));
            this.output = null;
            return this;
        }

        void flush() throws IOException {
            this.cache.flush();
        }

        void clear() throws IOException {
            this.cache.clear();
        }

        InputSocket<?> getInputSocket() {
            InputSocket<?> input = this.input;
            return null != input ? input : (this.input = this.cache.getInputSocket());
        }

        OutputSocket<?> getOutputSocket() {
            OutputSocket<?> output = this.output;
            return null != output ? output : (this.output = ENTRY_SOCKET_FACTORY.newOutputSocket(this, this.cache.getOutputSocket()));
        }

        void beginOutput() throws IOException {
            assert (FsCachingController.this.isWriteLockedByCurrentThread());
            FsCachingController.this.delegate.mknod(this.name, Entry.Type.FILE, this.outputOptions, this.template);
            assert (FsCachingController.this.isTouched());
        }

        void commitOutput() throws IOException {
            assert (FsCachingController.this.isWriteLockedByCurrentThread());
            assert (FsCachingController.this.isTouched());
            if (null != this.template) {
                return;
            }
            FsCachingController.this.delegate.mknod(this.name, Entry.Type.FILE, this.outputOptions.clear(FsOutputOption.EXCLUSIVE), this.cache.getEntry());
        }

        final class EntryOutputStream
        extends DecoratingOutputStream {
            EntryOutputStream(OutputStream out) {
                super(out);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                assert (FsCachingController.this.isWriteLockedByCurrentThread());
                try {
                    this.delegate.close();
                }
                finally {
                    EntryController.this.commitOutput();
                }
            }
        }

        final class EntrySeekableByteChannel
        extends DecoratingSeekableByteChannel {
            EntrySeekableByteChannel(SeekableByteChannel sbc) {
                super(sbc);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                assert (FsCachingController.this.isWriteLockedByCurrentThread());
                try {
                    this.delegate.close();
                }
                finally {
                    EntryController.this.commitOutput();
                }
            }
        }

        class EntryOutput
        extends DecoratingOutputSocket<Entry> {
            EntryOutput(OutputSocket<?> output) {
                super(output);
            }

            @Override
            public final OutputStream newOutputStream() throws IOException {
                EntryController.this.beginOutput();
                OutputStream out = this.getBoundSocket().newOutputStream();
                FsCachingController.this.controllers.put(EntryController.this.name, EntryController.this);
                return new EntryOutputStream(out);
            }
        }

        final class Nio2EntryOutput
        extends EntryOutput {
            Nio2EntryOutput(OutputSocket<?> output) {
                super(output);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                EntryController.this.beginOutput();
                SeekableByteChannel sbc = this.getBoundSocket().newSeekableByteChannel();
                FsCachingController.this.controllers.put(EntryController.this.name, EntryController.this);
                return new EntrySeekableByteChannel(sbc);
            }
        }

        final class EntryInputStream
        extends DecoratingInputStream {
            EntryInputStream(InputStream in) {
                super(in);
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
                FsCachingController.this.controllers.put(EntryController.this.name, EntryController.this);
            }
        }

        final class EntryInput
        extends DecoratingInputSocket<Entry> {
            EntryInput(InputSocket<?> input) {
                super(input);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() {
                throw new AssertionError();
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() {
                throw new AssertionError();
            }

            @Override
            public InputStream newInputStream() throws IOException {
                assert (FsCachingController.this.isWriteLockedByCurrentThread());
                InputStream in = this.getBoundSocket().newInputStream();
                assert (FsCachingController.this.isTouched());
                return new EntryInputStream(in);
            }
        }
    }

    @Immutable
    private static enum EntrySocketFactory {
        OIO{

            @Override
            OutputSocket<?> newOutputSocket(EntryController controller, OutputSocket<?> output) {
                EntryController entryController = controller;
                entryController.getClass();
                return entryController.new EntryController.EntryOutput(output);
            }
        }
        ,
        NIO2{

            @Override
            OutputSocket<?> newOutputSocket(EntryController controller, OutputSocket<?> output) {
                EntryController entryController = controller;
                entryController.getClass();
                return entryController.new EntryController.Nio2EntryOutput(output);
            }
        };


        abstract OutputSocket<?> newOutputSocket(EntryController var1, OutputSocket<?> var2);
    }

    private final class Output
    extends DecoratingOutputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsOutputOption> options;
        @CheckForNull
        final Entry template;

        Output(OutputSocket<?> output, FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(output);
            this.name = name;
            this.options = options;
            this.template = template;
        }

        @Override
        public OutputSocket<?> getBoundSocket() throws IOException {
            EntryController controller = (EntryController)FsCachingController.this.controllers.get(this.name);
            if (null == controller) {
                if (!this.options.get(FsOutputOption.CACHE)) {
                    return super.getBoundSocket();
                }
                controller = new EntryController(this.name);
            }
            return controller.configure(this.options, this.template).getOutputSocket().bind(this);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            return (Entry)this.getBoundSocket().getLocalTarget();
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return this.getBoundSocket().newSeekableByteChannel();
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return this.getBoundSocket().newOutputStream();
        }
    }

    private final class Input
    extends DecoratingInputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsInputOption> options;

        Input(InputSocket<?> input, FsEntryName name, BitField<FsInputOption> options) {
            super(input);
            this.name = name;
            this.options = options;
        }

        @Override
        public InputSocket<?> getBoundSocket() throws IOException {
            EntryController controller = (EntryController)FsCachingController.this.controllers.get(this.name);
            if (null == controller) {
                if (!this.options.get(FsInputOption.CACHE)) {
                    return super.getBoundSocket();
                }
                FsCachingController.this.assertWriteLockedByCurrentThread();
                controller = new EntryController(this.name);
            }
            return controller.configure(this.options).getInputSocket().bind(this);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            return (Entry)this.getBoundSocket().getLocalTarget();
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return this.getBoundSocket().newReadOnlyFile();
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return this.getBoundSocket().newSeekableByteChannel();
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.getBoundSocket().newInputStream();
        }
    }
}

