/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsCachingController;
import de.schlichtherle.truezip.fs.FsConcurrentController;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsResourceController;
import de.schlichtherle.truezip.fs.FsSyncController;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsContextController;
import de.schlichtherle.truezip.fs.archive.FsDefaultArchiveController;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public abstract class FsArchiveDriver<E extends FsArchiveEntry>
extends FsDriver {
    @Override
    public final boolean isFederated() {
        return true;
    }

    protected abstract IOPool<?> getPool();

    public boolean getRedundantContentSupport() {
        return false;
    }

    public boolean getRedundantMetaDataSupport() {
        return false;
    }

    @CheckForNull
    public Icon getOpenIcon(FsModel model) {
        return null;
    }

    @CheckForNull
    public Icon getClosedIcon(FsModel model) {
        return null;
    }

    @Override
    public FsController<?> newController(FsModel model, FsController<?> parent) {
        assert (!(model instanceof FsConcurrentModel));
        FsConcurrentModel cmodel = new FsConcurrentModel(model);
        return new FsSyncController<FsConcurrentModel>(new FsConcurrentController(new FsCachingController(new FsResourceController(new FsContextController(new FsDefaultArchiveController(cmodel, parent, this))), this.getPool())));
    }

    public InputSocket<?> getInputSocket(FsController<?> controller, FsEntryName name, BitField<FsInputOption> options) {
        return controller.getInputSocket(name, options);
    }

    public abstract InputShop<E> newInputShop(FsModel var1, InputSocket<?> var2) throws IOException;

    @Deprecated
    protected static ReadOnlyFile newReadOnlyFile(FsModel model, InputSocket<?> input) throws FsException, FileNotFoundException {
        try {
            return input.newReadOnlyFile();
        }
        catch (FsException ex) {
            throw ex;
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(model.getMountPoint().toString()).initCause(ex);
        }
    }

    @Deprecated
    protected static InputStream newInputStream(FsModel model, InputSocket<?> input) throws FsException, FileNotFoundException {
        try {
            return input.newInputStream();
        }
        catch (FsException ex) {
            throw ex;
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(model.getMountPoint().toString()).initCause(ex);
        }
    }

    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options, template);
    }

    public abstract OutputShop<E> newOutputShop(FsModel var1, OutputSocket<?> var2, @CheckForNull InputShop<E> var3) throws IOException;

    @Deprecated
    protected static OutputStream newOutputStream(FsModel model, OutputSocket<?> output) throws FsException, FileNotFoundException {
        try {
            return output.newOutputStream();
        }
        catch (FsException ex) {
            throw ex;
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(model.getMountPoint().toString()).initCause(ex);
        }
    }

    public final E newEntry(String name, Entry.Type type, @CheckForNull Entry template) throws CharConversionException {
        return this.newEntry(name, type, template, FsOutputOptions.NO_OUTPUT_OPTIONS);
    }

    public abstract E newEntry(String var1, Entry.Type var2, @CheckForNull Entry var3, BitField<FsOutputOption> var4) throws CharConversionException;
}

