/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@ThreadSafe
public final class Paths {
    private Paths() {
    }

    public static String normalize(String path, char separatorChar) {
        return new Normalizer(separatorChar).normalize(path);
    }

    public static String cutTrailingSeparators(String path, char separatorChar) {
        int i = path.length();
        if (0 >= i || separatorChar != path.charAt(--i)) {
            return path;
        }
        while (0 < i && separatorChar == path.charAt(--i)) {
        }
        return path.substring(0, ++i);
    }

    public static Splitter split(String path, char separatorChar, boolean keepTrailingSeparator) {
        return new Splitter(separatorChar, keepTrailingSeparator).split(path);
    }

    public static boolean isRoot(String path) {
        return path.isEmpty();
    }

    public static boolean isAbsolute(String path, char separatorChar) {
        int prefixLen = Paths.prefixLength(path, separatorChar, false);
        return 0 < prefixLen && separatorChar == path.charAt(prefixLen - 1);
    }

    public static int prefixLength(String path, char separatorChar, boolean inclUNC) {
        int pathLen = path.length();
        if (pathLen <= 0) {
            return 0;
        }
        char c = path.charAt(0);
        if ('\\' == File.separatorChar) {
            if (2 <= pathLen && ':' == path.charAt(1) && ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z')) {
                return 3 <= pathLen && separatorChar == path.charAt(2) ? 3 : 2;
            }
            if (separatorChar == c) {
                if (2 <= pathLen && separatorChar == path.charAt(1)) {
                    if (!inclUNC) {
                        return 2;
                    }
                    int i = path.indexOf(separatorChar, 2) + 1;
                    if (0 == i) {
                        return pathLen;
                    }
                    int j = path.indexOf(separatorChar, i) + 1;
                    if (0 == j) {
                        return pathLen;
                    }
                    return j;
                }
                return 1;
            }
            return 0;
        }
        return separatorChar == c ? 1 : 0;
    }

    public static boolean contains(String a, String b, char separatorChar) {
        int lengthB;
        if ('\\' == File.separatorChar) {
            a = a.toLowerCase();
            b = b.toLowerCase();
        }
        if (!b.startsWith(a)) {
            return false;
        }
        int lengthA = a.length();
        if (lengthA == (lengthB = b.length())) {
            return true;
        }
        if (lengthA < lengthB) {
            return b.charAt(lengthA) == separatorChar;
        }
        return false;
    }

    @NotThreadSafe
    public static class Splitter {
        private final char separatorChar;
        private final int fixum;
        @CheckForNull
        private String parentPath;
        private String memberName;

        public Splitter(char separatorChar, boolean keepTrailingSeparator) {
            this.separatorChar = separatorChar;
            this.fixum = keepTrailingSeparator ? 1 : 0;
        }

        public Splitter split(String path) {
            int memberEnd;
            int prefixLen = Paths.prefixLength(path, this.separatorChar, false);
            if (prefixLen > (memberEnd = path.length() - 1)) {
                this.parentPath = null;
                this.memberName = "";
                return this;
            }
            memberEnd = Splitter.lastIndexNot(path, this.separatorChar, memberEnd);
            int memberInd = path.lastIndexOf(this.separatorChar, memberEnd) + 1;
            if (prefixLen >= ++memberEnd) {
                this.parentPath = null;
                this.memberName = "";
            } else if (prefixLen >= memberInd) {
                this.parentPath = 0 >= prefixLen ? null : path.substring(0, prefixLen);
                this.memberName = path.substring(prefixLen, memberEnd);
            } else {
                int parentEnd = Splitter.lastIndexNot(path, this.separatorChar, memberInd - 1) + 1;
                if (prefixLen >= parentEnd) {
                    this.parentPath = path.substring(0, prefixLen);
                    this.memberName = path.substring(memberInd, memberEnd);
                } else {
                    this.parentPath = path.substring(0, parentEnd + this.fixum);
                    this.memberName = path.substring(memberInd, memberEnd);
                }
            }
            return this;
        }

        private static int lastIndexNot(String path, char separatorChar, int last) {
            while (separatorChar == path.charAt(last) && --last >= 0) {
            }
            return last;
        }

        @Nullable
        public String getParentPath() {
            return this.parentPath;
        }

        public String getMemberName() {
            return this.memberName;
        }
    }

    @NotThreadSafe
    public static class Normalizer {
        private final char separatorChar;
        private String path;
        private final StringBuilder buffer;

        public Normalizer(char separatorChar) {
            this.separatorChar = separatorChar;
            this.buffer = new StringBuilder();
        }

        public String normalize(String path) {
            String result;
            int prefixLen = Paths.prefixLength(path, this.separatorChar, false);
            int pathLen = path.length();
            this.path = path.substring(prefixLen, pathLen);
            this.buffer.setLength(0);
            this.buffer.ensureCapacity(pathLen);
            this.normalize(0, pathLen - prefixLen);
            this.buffer.insert(0, path.substring(0, prefixLen));
            int bufferLen = this.buffer.length();
            if (pathLen > 0 && path.charAt(pathLen - 1) == this.separatorChar || pathLen > 1 && path.charAt(pathLen - 2) == this.separatorChar && path.charAt(pathLen - 1) == '.') {
                this.slashify();
                bufferLen = this.buffer.length();
            }
            if (bufferLen == path.length()) {
                assert (path.equals(this.buffer.toString()));
                result = path;
            } else {
                result = this.buffer.toString();
                if (path.startsWith(result)) {
                    result = path.substring(0, bufferLen);
                }
            }
            assert (!result.equals(path) || result == path);
            return result;
        }

        private int normalize(int collapse, int end) {
            int notCollapsed;
            assert (collapse >= 0);
            if (0 >= end) {
                return collapse;
            }
            int next = this.path.lastIndexOf(this.separatorChar, end - 1);
            String base = this.path.substring(next + 1, end);
            if (0 >= base.length() || ".".equals(base)) {
                return this.normalize(collapse, next);
            }
            if ("..".equals(base)) {
                notCollapsed = this.normalize(collapse + 1, next) - 1;
                if (0 > notCollapsed) {
                    return 0;
                }
            } else {
                if (0 < collapse) {
                    int notCollapsed2 = this.normalize(collapse - 1, next);
                    this.slashify();
                    return notCollapsed2;
                }
                assert (0 == collapse);
                notCollapsed = this.normalize(0, next);
                assert (0 == notCollapsed);
            }
            this.slashify();
            this.buffer.append(base);
            return notCollapsed;
        }

        private void slashify() {
            int bufferLen = this.buffer.length();
            if (bufferLen > 0 && this.buffer.charAt(bufferLen - 1) != this.separatorChar) {
                this.buffer.append(this.separatorChar);
            }
        }
    }
}

