/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.SynchronizedInputStream;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.SynchronizedReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputShop;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class SynchronizedInputShop<E extends Entry>
extends DecoratingInputShop<E, InputShop<E>> {
    public SynchronizedInputShop(InputShop<E> input) {
        super(input);
    }

    public InputShop<E> getDelegate() {
        return (InputShop)this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        InputShop inputShop = (InputShop)this.delegate;
        synchronized (inputShop) {
            ((InputShop)this.delegate).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getEntry(String name) {
        InputShop inputShop = (InputShop)this.delegate;
        synchronized (inputShop) {
            return ((InputShop)this.delegate).getEntry(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        InputShop inputShop = (InputShop)this.delegate;
        synchronized (inputShop) {
            return ((InputShop)this.delegate).getSize();
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("This method cannot be thread-safe - use getDelegate().iterator() instead!");
    }

    @Override
    public InputSocket<? extends E> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        class Input
        extends DecoratingInputSocket<E> {
            Input() {
                super(SynchronizedInputShop.super.getInputSocket(string));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                InputShop inputShop = (InputShop)SynchronizedInputShop.this.delegate;
                synchronized (inputShop) {
                    return new SynchronizedReadOnlyFile(this.getBoundSocket().newReadOnlyFile(), SynchronizedInputShop.this.delegate);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputStream newInputStream() throws IOException {
                InputShop inputShop = (InputShop)SynchronizedInputShop.this.delegate;
                synchronized (inputShop) {
                    return new SynchronizedInputStream(this.getBoundSocket().newInputStream(), SynchronizedInputShop.this.delegate);
                }
            }
        }
        return new Input();
    }
}

