/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.ExceptionBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class AbstractExceptionBuilder<C extends Exception, E extends Exception>
implements ExceptionBuilder<C, E> {
    @CheckForNull
    private E assembly;

    protected abstract E update(C var1, @CheckForNull E var2);

    protected E post(E assembly) {
        return assembly;
    }

    @Override
    public final E fail(C cause) {
        if (null == cause) {
            throw new NullPointerException();
        }
        E assembly = this.update(cause, this.assembly);
        this.assembly = null;
        return this.post(assembly);
    }

    @Override
    public final void warn(C cause) {
        if (null == cause) {
            throw new NullPointerException();
        }
        this.assembly = this.update(cause, this.assembly);
    }

    @Override
    public final void check() throws E {
        E assembly = this.assembly;
        if (null != assembly) {
            this.assembly = null;
            throw this.post(assembly);
        }
    }
}

