/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong$PyExposer;
import org.python.core.PyLongDerived;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="long", doc="long(x[, base]) -> integer\n\nConvert a string or number to a long integer, if possible.  A floating\npoint argument will be truncated towards zero (this does not include a\nstring representation of a floating point number!)  When converting a\nstring, use the optional base.  It is an error to supply a base when\nconverting a non-string.")
public class PyLong
extends PyObject {
    public static final PyType TYPE;
    public static final BigInteger MIN_LONG;
    public static final BigInteger MAX_LONG;
    public static final BigInteger MAX_ULONG;
    @Deprecated
    public static final BigInteger minLong;
    @Deprecated
    public static final BigInteger maxLong;
    @Deprecated
    public static final BigInteger maxULong;
    private final BigInteger value;

    public BigInteger getValue() {
        return this.value;
    }

    public PyLong(PyType subType, BigInteger v) {
        super(subType);
        this.value = v;
    }

    public PyLong(BigInteger v) {
        this(TYPE, v);
    }

    public PyLong(double v) {
        this(PyLong.toBigInteger(v));
    }

    public PyLong(long v) {
        this(BigInteger.valueOf(v));
    }

    public PyLong(String s) {
        this(new BigInteger(s));
    }

    @ExposedNew
    public static PyObject long___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (new_.for_type != subtype) {
            return PyLong.longSubtypeNew(new_, init, subtype, args, keywords);
        }
        ArgParser ap = new ArgParser("long", args, keywords, new String[]{"x", "base"}, 0);
        PyObject x = ap.getPyObject(0, null);
        if (x != null && x.getJavaProxy() instanceof BigInteger) {
            return new PyLong((BigInteger)x.getJavaProxy());
        }
        int base = ap.getInt(1, -909);
        if (x == null) {
            return new PyLong(0L);
        }
        if (base == -909) {
            return PyLong.asPyLong(x);
        }
        if (!(x instanceof PyString)) {
            throw Py.TypeError("long: can't convert non-string with explicit base");
        }
        return ((PyString)x).atol(base);
    }

    private static PyObject asPyLong(PyObject x) {
        try {
            return x.__long__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.AttributeError)) {
                throw pye;
            }
            try {
                PyObject integral = x.invoke("__trunc__");
                return PyLong.convertIntegralToLong(integral);
            }
            catch (PyException pye2) {
                if (!pye2.match(Py.AttributeError)) {
                    throw pye2;
                }
                throw Py.TypeError(String.format("long() argument must be a string or a number, not '%.200s'", x.getType().fastGetName()));
            }
        }
    }

    private static PyObject convertIntegralToLong(PyObject integral) {
        if (!(integral instanceof PyInteger) && !(integral instanceof PyLong)) {
            PyObject i = integral.invoke("__int__");
            if (!(i instanceof PyInteger) && !(i instanceof PyLong)) {
                throw Py.TypeError(String.format("__trunc__ returned non-Integral (type %.200s)", integral.getType().fastGetName()));
            }
            return i;
        }
        return integral;
    }

    private static PyObject longSubtypeNew(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        PyObject tmp = PyLong.long___new__(new_, init, TYPE, args, keywords);
        if (tmp instanceof PyInteger) {
            int intValue = ((PyInteger)tmp).getValue();
            return new PyLongDerived(subtype, BigInteger.valueOf(intValue));
        }
        return new PyLongDerived(subtype, ((PyLong)tmp).getValue());
    }

    private static BigInteger toBigInteger(double value) {
        if (Double.isInfinite(value)) {
            throw Py.OverflowError("cannot convert float infinity to long");
        }
        if (Double.isNaN(value)) {
            throw Py.ValueError("cannot convert float NaN to integer");
        }
        return new BigDecimal(value).toBigInteger();
    }

    public PyObject getReal() {
        return this.long___long__();
    }

    public PyObject getImag() {
        return Py.newLong(0);
    }

    public PyObject getNumerator() {
        return this.long___long__();
    }

    public PyObject getDenominator() {
        return Py.newLong(1);
    }

    @Override
    public String toString() {
        return this.long_toString();
    }

    final String long_toString() {
        return this.getValue().toString() + "L";
    }

    @Override
    public int hashCode() {
        return this.long___hash__();
    }

    final int long___hash__() {
        return this.getValue().hashCode();
    }

    @Override
    public boolean __nonzero__() {
        return this.long___nonzero__();
    }

    public boolean long___nonzero__() {
        return !this.getValue().equals(BigInteger.ZERO);
    }

    public double doubleValue() {
        double v = this.getValue().doubleValue();
        if (Double.isInfinite(v)) {
            throw Py.OverflowError("long int too large to convert to float");
        }
        return v;
    }

    private static final double scaledDoubleValue(BigInteger val, int[] exp) {
        double x = 0.0;
        int signum = val.signum();
        byte[] digits = signum >= 0 ? val.toByteArray() : val.negate().toByteArray();
        int count2 = 8;
        int i = 0;
        if (digits[0] == 0) {
            ++i;
            ++count2;
        }
        int n = count2 = count2 <= digits.length ? count2 : digits.length;
        while (i < count2) {
            x = x * 256.0 + (double)(digits[i] & 0xFF);
            ++i;
        }
        exp[0] = digits.length - i;
        return (double)signum * x;
    }

    public double scaledDoubleValue(int[] exp) {
        return PyLong.scaledDoubleValue(this.getValue(), exp);
    }

    public long getLong(long min, long max) {
        return this.getLong(min, max, "long int too large to convert");
    }

    public long getLong(long min, long max, String overflowMsg) {
        long v;
        if (this.getValue().compareTo(MAX_LONG) <= 0 && this.getValue().compareTo(MIN_LONG) >= 0 && (v = this.getValue().longValue()) >= min && v <= max) {
            return v;
        }
        throw Py.OverflowError(overflowMsg);
    }

    @Override
    public long asLong(int index) {
        return this.asLong();
    }

    @Override
    public int asInt(int index) {
        return (int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE, "long int too large to convert to int");
    }

    @Override
    public int asInt() {
        return (int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE, "long int too large to convert to int");
    }

    @Override
    public long asLong() {
        return this.getLong(Long.MIN_VALUE, Long.MAX_VALUE, "long too big to convert");
    }

    @Override
    public Object __tojava__(Class<?> c) {
        try {
            if (c == Byte.TYPE || c == Byte.class) {
                return new Byte((byte)this.getLong(-128L, 127L));
            }
            if (c == Short.TYPE || c == Short.class) {
                return new Short((short)this.getLong(-32768L, 32767L));
            }
            if (c == Integer.TYPE || c == Integer.class) {
                return new Integer((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
            }
            if (c == Long.TYPE || c == Long.class) {
                return new Long(this.getLong(Long.MIN_VALUE, Long.MAX_VALUE));
            }
            if (c == Float.TYPE || c == Double.TYPE || c == Float.class || c == Double.class) {
                return this.__float__().__tojava__(c);
            }
            if (c == BigInteger.class || c == Number.class || c == Object.class || c == Serializable.class) {
                return this.getValue();
            }
        }
        catch (PyException e) {
            return Py.NoConversion;
        }
        return super.__tojava__(c);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.long___cmp__(other);
    }

    final int long___cmp__(PyObject other) {
        if (!PyLong.canCoerce(other)) {
            return -2;
        }
        return this.getValue().compareTo(PyLong.coerce(other));
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        return this.long___coerce_ex__(other);
    }

    final PyObject long___coerce__(PyObject other) {
        return this.adaptToCoerceTuple(this.long___coerce_ex__(other));
    }

    final Object long___coerce_ex__(PyObject other) {
        if (other instanceof PyLong) {
            return other;
        }
        if (other instanceof PyInteger) {
            return Py.newLong(((PyInteger)other).getValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyLong || other instanceof PyInteger;
    }

    private static final BigInteger coerce(PyObject other) {
        if (other instanceof PyLong) {
            return ((PyLong)other).getValue();
        }
        if (other instanceof PyInteger) {
            return BigInteger.valueOf(((PyInteger)other).getValue());
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        return this.long___add__(right);
    }

    final PyObject long___add__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return Py.newLong(this.getValue().add(PyLong.coerce(right)));
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.long___radd__(left);
    }

    final PyObject long___radd__(PyObject left) {
        return this.__add__(left);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        return this.long___sub__(right);
    }

    final PyObject long___sub__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return Py.newLong(this.getValue().subtract(PyLong.coerce(right)));
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        return this.long___rsub__(left);
    }

    final PyObject long___rsub__(PyObject left) {
        return Py.newLong(PyLong.coerce(left).subtract(this.getValue()));
    }

    @Override
    public PyObject __mul__(PyObject right) {
        return this.long___mul__(right);
    }

    final PyObject long___mul__(PyObject right) {
        if (right instanceof PySequence) {
            return ((PySequence)right).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return Py.newLong(this.getValue().multiply(PyLong.coerce(right)));
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        return this.long___rmul__(left);
    }

    final PyObject long___rmul__(PyObject left) {
        if (left instanceof PySequence) {
            return ((PySequence)left).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return Py.newLong(PyLong.coerce(left).multiply(this.getValue()));
    }

    private BigInteger divide(BigInteger x, BigInteger y) {
        BigInteger zero = BigInteger.valueOf(0L);
        if (y.equals(zero)) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        if (y.compareTo(zero) < 0) {
            if (x.compareTo(zero) > 0) {
                return x.subtract(y).subtract(BigInteger.valueOf(1L)).divide(y);
            }
        } else if (x.compareTo(zero) < 0) {
            return x.subtract(y).add(BigInteger.valueOf(1L)).divide(y);
        }
        return x.divide(y);
    }

    @Override
    public PyObject __div__(PyObject right) {
        return this.long___div__(right);
    }

    final PyObject long___div__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        if (Options.division_warning > 0) {
            Py.warning(Py.DeprecationWarning, "classic long division");
        }
        return Py.newLong(this.divide(this.getValue(), PyLong.coerce(right)));
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        return this.long___rdiv__(left);
    }

    final PyObject long___rdiv__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        if (Options.division_warning > 0) {
            Py.warning(Py.DeprecationWarning, "classic long division");
        }
        return Py.newLong(this.divide(PyLong.coerce(left), this.getValue()));
    }

    @Override
    public PyObject __floordiv__(PyObject right) {
        return this.long___floordiv__(right);
    }

    final PyObject long___floordiv__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return Py.newLong(this.divide(this.getValue(), PyLong.coerce(right)));
    }

    @Override
    public PyObject __rfloordiv__(PyObject left) {
        return this.long___rfloordiv__(left);
    }

    final PyObject long___rfloordiv__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return Py.newLong(this.divide(PyLong.coerce(left), this.getValue()));
    }

    private static final PyFloat true_divide(BigInteger a, BigInteger b) {
        int[] ae = new int[1];
        int[] be = new int[1];
        double ad = PyLong.scaledDoubleValue(a, ae);
        double bd = PyLong.scaledDoubleValue(b, be);
        if (bd == 0.0) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        ad /= bd;
        int aexp = ae[0] - be[0];
        if (aexp > 0xFFFFFFF) {
            throw Py.OverflowError("long/long too large for a float");
        }
        if (aexp < -268435455) {
            return new PyFloat(0.0);
        }
        if (Double.isInfinite(ad *= Math.pow(2.0, aexp * 8))) {
            throw Py.OverflowError("long/long too large for a float");
        }
        return new PyFloat(ad);
    }

    @Override
    public PyObject __truediv__(PyObject right) {
        return this.long___truediv__(right);
    }

    final PyObject long___truediv__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return PyLong.true_divide(this.getValue(), PyLong.coerce(right));
    }

    @Override
    public PyObject __rtruediv__(PyObject left) {
        return this.long___rtruediv__(left);
    }

    final PyObject long___rtruediv__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return PyLong.true_divide(PyLong.coerce(left), this.getValue());
    }

    private BigInteger modulo(BigInteger x, BigInteger y, BigInteger xdivy) {
        return x.subtract(xdivy.multiply(y));
    }

    @Override
    public PyObject __mod__(PyObject right) {
        return this.long___mod__(right);
    }

    final PyObject long___mod__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        BigInteger rightv = PyLong.coerce(right);
        return Py.newLong(this.modulo(this.getValue(), rightv, this.divide(this.getValue(), rightv)));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        return this.long___rmod__(left);
    }

    final PyObject long___rmod__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        BigInteger leftv = PyLong.coerce(left);
        return Py.newLong(this.modulo(leftv, this.getValue(), this.divide(leftv, this.getValue())));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        return this.long___divmod__(right);
    }

    final PyObject long___divmod__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        BigInteger rightv = PyLong.coerce(right);
        BigInteger xdivy = this.divide(this.getValue(), rightv);
        return new PyTuple(Py.newLong(xdivy), Py.newLong(this.modulo(this.getValue(), rightv, xdivy)));
    }

    @Override
    public PyObject __rdivmod__(PyObject left) {
        return this.long___rdivmod__(left);
    }

    final PyObject long___rdivmod__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        BigInteger leftv = PyLong.coerce(left);
        BigInteger xdivy = this.divide(leftv, this.getValue());
        return new PyTuple(Py.newLong(xdivy), Py.newLong(this.modulo(leftv, this.getValue(), xdivy)));
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.long___pow__(right, modulo);
    }

    final PyObject long___pow__(PyObject right, PyObject modulo) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyLong.canCoerce(right)) {
            return null;
        }
        return PyLong._pow(this.getValue(), PyLong.coerce(right), modulo, this, right);
    }

    @Override
    public PyObject __rpow__(PyObject left) {
        return this.long___rpow__(left);
    }

    final PyObject long___rpow__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return PyLong._pow(PyLong.coerce(left), this.getValue(), null, left, this);
    }

    public static PyObject _pow(BigInteger value, BigInteger y, PyObject modulo, PyObject left, PyObject right) {
        if (y.compareTo(BigInteger.ZERO) < 0) {
            if (value.compareTo(BigInteger.ZERO) != 0) {
                return left.__float__().__pow__(right, modulo);
            }
            throw Py.ZeroDivisionError("zero to a negative power");
        }
        if (modulo == null) {
            return Py.newLong(value.pow(y.intValue()));
        }
        BigInteger z = PyLong.coerce(modulo);
        if (z.equals(BigInteger.ZERO)) {
            throw Py.ValueError("pow(x, y, z) with z == 0");
        }
        if (z.abs().equals(BigInteger.ONE)) {
            return Py.newLong(0);
        }
        if (z.compareTo(BigInteger.valueOf(0L)) <= 0) {
            if ((y = value.modPow(y, z.negate())).compareTo(BigInteger.valueOf(0L)) > 0) {
                return Py.newLong(z.add(y));
            }
            return Py.newLong(y);
        }
        return Py.newLong(value.modPow(y, z));
    }

    private static final int coerceInt(PyObject other) {
        if (other instanceof PyLong) {
            return ((PyLong)other).asInt();
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __lshift__(PyObject right) {
        return this.long___lshift__(right);
    }

    final PyObject long___lshift__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        int rightv = PyLong.coerceInt(right);
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newLong(this.getValue().shiftLeft(rightv));
    }

    final PyObject long___rlshift__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        if (this.getValue().intValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newLong(PyLong.coerce(left).shiftLeft(PyLong.coerceInt(this)));
    }

    @Override
    public PyObject __rshift__(PyObject right) {
        return this.long___rshift__(right);
    }

    final PyObject long___rshift__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        int rightv = PyLong.coerceInt(right);
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newLong(this.getValue().shiftRight(rightv));
    }

    final PyObject long___rrshift__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        if (this.getValue().intValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newLong(PyLong.coerce(left).shiftRight(PyLong.coerceInt(this)));
    }

    @Override
    public PyObject __and__(PyObject right) {
        return this.long___and__(right);
    }

    final PyObject long___and__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return Py.newLong(this.getValue().and(PyLong.coerce(right)));
    }

    @Override
    public PyObject __rand__(PyObject left) {
        return this.long___rand__(left);
    }

    final PyObject long___rand__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return Py.newLong(PyLong.coerce(left).and(this.getValue()));
    }

    @Override
    public PyObject __xor__(PyObject right) {
        return this.long___xor__(right);
    }

    final PyObject long___xor__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return Py.newLong(this.getValue().xor(PyLong.coerce(right)));
    }

    @Override
    public PyObject __rxor__(PyObject left) {
        return this.long___rxor__(left);
    }

    final PyObject long___rxor__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return Py.newLong(PyLong.coerce(left).xor(this.getValue()));
    }

    @Override
    public PyObject __or__(PyObject right) {
        return this.long___or__(right);
    }

    final PyObject long___or__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return Py.newLong(this.getValue().or(PyLong.coerce(right)));
    }

    @Override
    public PyObject __ror__(PyObject left) {
        return this.long___ror__(left);
    }

    final PyObject long___ror__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return Py.newLong(PyLong.coerce(left).or(this.getValue()));
    }

    @Override
    public PyObject __neg__() {
        return this.long___neg__();
    }

    final PyObject long___neg__() {
        return Py.newLong(this.getValue().negate());
    }

    @Override
    public PyObject __pos__() {
        return this.long___pos__();
    }

    final PyObject long___pos__() {
        return this.long___long__();
    }

    @Override
    public PyObject __abs__() {
        return this.long___abs__();
    }

    final PyObject long___abs__() {
        if (this.getValue().signum() == -1) {
            return this.long___neg__();
        }
        return this.long___long__();
    }

    @Override
    public PyObject __invert__() {
        return this.long___invert__();
    }

    final PyObject long___invert__() {
        return Py.newLong(this.getValue().not());
    }

    @Override
    public PyObject __int__() {
        return this.long___int__();
    }

    final PyObject long___int__() {
        if (this.getValue().compareTo(PyInteger.MAX_INT) <= 0 && this.getValue().compareTo(PyInteger.MIN_INT) >= 0) {
            return Py.newInteger(this.getValue().intValue());
        }
        return this.long___long__();
    }

    @Override
    public PyObject __long__() {
        return this.long___long__();
    }

    final PyObject long___long__() {
        return this.getType() == TYPE ? this : Py.newLong(this.getValue());
    }

    @Override
    public PyFloat __float__() {
        return this.long___float__();
    }

    final PyFloat long___float__() {
        return new PyFloat(this.doubleValue());
    }

    @Override
    public PyComplex __complex__() {
        return this.long___complex__();
    }

    final PyComplex long___complex__() {
        return new PyComplex(this.doubleValue(), 0.0);
    }

    @Override
    public PyObject __trunc__() {
        return this.long___trunc__();
    }

    final PyObject long___trunc__() {
        return this;
    }

    @Override
    public PyObject conjugate() {
        return this.long_conjugate();
    }

    final PyObject long_conjugate() {
        return this;
    }

    @Override
    public PyString __oct__() {
        return this.long___oct__();
    }

    final PyString long___oct__() {
        String s = PyInteger.toOctString(this.getValue());
        if (s.startsWith("-")) {
            return new PyString("-0" + s.substring(1, s.length()) + "L");
        }
        if (s.startsWith("0")) {
            return new PyString(s + "L");
        }
        return new PyString("0" + s + "L");
    }

    @Override
    public PyString __hex__() {
        return this.long___hex__();
    }

    final PyString long___hex__() {
        String s = PyInteger.toHexString(this.getValue());
        if (s.startsWith("-")) {
            return new PyString("-0x" + s.substring(1, s.length()) + "L");
        }
        return new PyString("0x" + s + "L");
    }

    public PyString long___str__() {
        return Py.newString(this.getValue().toString());
    }

    @Override
    public PyString __str__() {
        return this.long___str__();
    }

    @Override
    public PyUnicode __unicode__() {
        return new PyUnicode(this.getValue().toString());
    }

    final PyTuple long___getnewargs__() {
        return new PyTuple(new PyLong(this.getValue()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.long___getnewargs__();
    }

    @Override
    public PyObject __index__() {
        return this.long___index__();
    }

    final PyObject long___index__() {
        return this;
    }

    @Override
    public int bit_length() {
        return this.long_bit_length();
    }

    final int long_bit_length() {
        BigInteger v = this.value;
        if (v.compareTo(BigInteger.ZERO) == -1) {
            v = v.negate();
        }
        return v.bitLength();
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.long___format__(formatSpec);
    }

    final PyObject long___format__(PyObject formatSpec) {
        return PyInteger.formatImpl(this.getValue(), formatSpec);
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    @Override
    public int asIndex(PyObject err) {
        boolean tooHigh;
        boolean tooLow = this.getValue().compareTo(PyInteger.MIN_INT) < 0;
        boolean bl = tooHigh = this.getValue().compareTo(PyInteger.MAX_INT) > 0;
        if (tooLow || tooHigh) {
            if (err != null) {
                throw new PyException(err, "cannot fit 'long' into an index-sized integer");
            }
            return tooLow ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        return (int)this.getValue().longValue();
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    static {
        PyType.addBuilder(PyLong.class, new PyLong$PyExposer());
        TYPE = PyType.fromClass(PyLong.class);
        MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        MAX_ULONG = BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.valueOf(1L));
        minLong = MIN_LONG;
        maxLong = MAX_LONG;
        maxULong = MAX_ULONG;
    }
}

