/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JOptionPane;

public class Windows {
    private static final String PROPERTY_FOCUSED_WINDOW = "focusedWindow";
    private static Reference<KeyboardFocusManager> lastFocusManager = new WeakReference<Object>(null);
    private static Reference<Window> lastFocusedWindow = new WeakReference<Object>(null);
    private static PropertyChangeListener focusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Windows.setLastFocusedWindow((Window)evt.getNewValue());
        }
    };

    private Windows() {
    }

    public static synchronized Window getParentWindow() {
        Window w = Windows.findFirstShowingWindow(Windows.getLastFocusedWindow());
        if (w == null) {
            w = Windows.getAnyShowingWindow();
        }
        return w != null ? w : JOptionPane.getRootFrame();
    }

    private static Window findFirstShowingWindow(Window w) {
        for (Container c = w; c != null; c = c.getParent()) {
            if (!(c instanceof Window) || !((Component)c).isShowing()) continue;
            return c;
        }
        return null;
    }

    public static Window getLastFocusedWindow() {
        Windows.observeFocusedWindow();
        return lastFocusedWindow.get();
    }

    private static void observeFocusedWindow() {
        KeyboardFocusManager lfm = lastFocusManager.get();
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (fm == lfm) {
            return;
        }
        if (lfm != null) {
            lfm.removePropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        }
        fm.addPropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        lastFocusManager = new WeakReference<KeyboardFocusManager>(fm);
        Windows.setLastFocusedWindow0(fm.getFocusedWindow());
    }

    private static synchronized void setLastFocusedWindow(Window w) {
        Windows.setLastFocusedWindow0(w);
    }

    private static void setLastFocusedWindow0(Window w) {
        if (!(w != null && w.isShowing() || (w = lastFocusedWindow.get()) == null || w.isShowing())) {
            w = null;
        }
        lastFocusedWindow = new WeakReference<Window>(w);
    }

    private static Window getAnyShowingWindow() {
        return Windows.getAnyShowingWindow(Frame.getFrames());
    }

    private static Window getAnyShowingWindow(Window[] windows) {
        for (Window window : windows) {
            if (window.isShowing()) {
                return window;
            }
            if ((window = Windows.getAnyShowingWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }
}

