/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto;

import de.schlichtherle.truezip.io.DecoratingOutputStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;

@DefaultAnnotation(value={NonNull.class})
public class CipherOutputStream
extends DecoratingOutputStream {
    @Nullable
    protected BufferedBlockCipher cipher;
    private byte[] cipherOut = new byte[0];
    private boolean closed;

    public CipherOutputStream(@CheckForNull OutputStream out, @CheckForNull BufferedBlockCipher cipher) {
        super(out);
        this.cipher = cipher;
    }

    private void assertOpen() throws IOException {
        if (null == this.cipher) {
            throw new IOException("cipher output stream is not in open state");
        }
    }

    public void write(int b) throws IOException {
        this.assertOpen();
        int cipherLen = this.cipher.getUpdateOutputSize(1);
        byte[] cipherOut = this.cipherOut;
        if (cipherLen > cipherOut.length) {
            cipherOut = this.cipherOut = new byte[cipherLen];
        }
        if ((cipherLen = this.cipher.processByte((byte)b, cipherOut, 0)) > 0) {
            this.delegate.write(cipherOut, 0, cipherLen);
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.assertOpen();
        int cipherLen = this.cipher.getUpdateOutputSize(len);
        byte[] cipherOut = this.cipherOut;
        if (cipherLen > cipherOut.length) {
            cipherOut = this.cipherOut = new byte[cipherLen];
        }
        cipherLen = this.cipher.processBytes(buf, off, len, cipherOut, 0);
        this.delegate.write(cipherOut, 0, cipherLen);
    }

    protected void finish() throws IOException {
        this.assertOpen();
        int cipherLen = this.cipher.getOutputSize(0);
        byte[] cipherOut = this.cipherOut;
        if (cipherLen > cipherOut.length) {
            cipherOut = this.cipherOut = new byte[cipherLen];
        }
        try {
            cipherLen = this.cipher.doFinal(cipherOut, 0);
        }
        catch (InvalidCipherTextException ex) {
            throw new IOException(ex);
        }
        this.delegate.write(cipherOut, 0, cipherLen);
        this.delegate.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.finish();
        }
        finally {
            this.cipher = null;
            this.delegate.close();
        }
    }
}

