/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe;

import de.schlichtherle.truezip.crypto.param.KeyStrength;
import de.schlichtherle.truezip.key.SafeKey;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class SafePbeParameters<S extends KeyStrength, P extends SafePbeParameters<S, P>>
implements SafeKey<P> {
    @CheckForNull
    private char[] password;
    @CheckForNull
    private S keyStrength;

    @Override
    public P clone() {
        SafePbeParameters clone;
        try {
            clone = (SafePbeParameters)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
        char[] password = this.password;
        if (null != password) {
            clone.password = (char[])password.clone();
        }
        return (P)clone;
    }

    @Override
    public void reset() {
        this.setPassword(null);
        this.setKeyStrength(null);
    }

    @Nullable
    public char[] getPassword() {
        return null == this.password ? null : (char[])this.password.clone();
    }

    public void setPassword(@CheckForNull char[] newPW) {
        char[] oldPW = this.password;
        if (null != oldPW) {
            Arrays.fill(oldPW, '\u0000');
        }
        this.password = null == newPW ? null : (char[])newPW.clone();
    }

    public void setKeyFileBytes(@CheckForNull byte[] bytes) {
        char[] oldPW = this.password;
        if (null != oldPW) {
            Arrays.fill(oldPW, '\u0000');
        }
        if (null != bytes) {
            int len = bytes.length;
            char[] newPW = new char[len >>= 1];
            int off = 0;
            for (int i = 0; i < len; ++i) {
                newPW[i] = (char)(bytes[off++] << 8 | bytes[off++] & 0xFF);
            }
            this.password = newPW;
        } else {
            this.password = null;
        }
    }

    public abstract S[] getKeyStrengthValues();

    @Nullable
    public S getKeyStrength() {
        return this.keyStrength;
    }

    public void setKeyStrength(@CheckForNull S keyStrength) {
        this.keyStrength = keyStrength;
    }
}

