/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.swing.TDecoratingFileView;
import de.schlichtherle.truezip.file.swing.TNullFileView;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;

@DefaultAnnotation(value={NonNull.class})
public class TFileView
extends TDecoratingFileView {
    private static final String CLASS_NAME = TFileView.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);

    public TFileView(@CheckForNull FileView fileView) {
        super(null != fileView ? fileView : new TNullFileView());
    }

    @Override
    @Nullable
    public String getTypeDescription(File file) {
        String typeDescription = TFileView.typeDescription(file);
        return typeDescription != null ? typeDescription : this.delegate.getTypeDescription(file);
    }

    @Nullable
    static String typeDescription(File file) {
        return file instanceof TFile ? TFileView.typeDescription((TFile)file) : null;
    }

    @Nullable
    private static String typeDescription(TFile file) {
        if (TFileView.isTrueArchive(file)) {
            return resources.getString("archiveFile");
        }
        if (TFileView.isTrueEntry(file)) {
            return file.isDirectory() ? resources.getString("archiveDirectoryEntry") : (file.isFile() ? resources.getString("archiveFileEntry") : null);
        }
        return null;
    }

    @Override
    @Nullable
    public Icon getIcon(File file) {
        Icon icon = TFileView.icon(file);
        return null != icon ? icon : this.delegate.getIcon(file);
    }

    @Nullable
    static Icon icon(File file) {
        return file instanceof TFile ? TFileView.icon((TFile)file) : null;
    }

    @Nullable
    private static Icon icon(TFile file) {
        if (TFileView.isTrueArchive(file)) {
            return UIManager.getIcon("FileView.directoryIcon");
        }
        if (TFileView.isTrueEntry(file)) {
            return file.isDirectory() ? UIManager.getIcon("FileView.directoryIcon") : (file.isFile() ? UIManager.getIcon("FileView.fileIcon") : null);
        }
        return null;
    }

    private static boolean isTrueArchive(TFile file) {
        return file.isArchive() && file.isDirectory();
    }

    private static boolean isTrueEntry(TFile file) {
        if (!file.isEntry()) {
            return false;
        }
        TFile parent = file.getParentFile();
        assert (parent != null) : "An archive entry must always name a parent!";
        return parent.isDirectory();
    }

    @Override
    @Nullable
    public Boolean isTraversable(File file) {
        return file instanceof TFile ? Boolean.valueOf(((TFile)file).isDirectory()) : this.delegate.isTraversable(file);
    }
}

