/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.RamUsageEstimator;

public final class BytesRefArray {
    private final ByteBlockPool pool;
    private int[] offsets = new int[1];
    private int lastElement = 0;
    private int currentOffset = 0;
    private final Counter bytesUsed;

    public BytesRefArray(Counter bytesUsed) {
        this.pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
        this.pool.nextBuffer();
        bytesUsed.addAndGet(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 4);
        this.bytesUsed = bytesUsed;
    }

    public void clear() {
        this.lastElement = 0;
        this.currentOffset = 0;
        Arrays.fill(this.offsets, 0);
        this.pool.reset(false, true);
    }

    public int append(BytesRef bytes) {
        if (this.lastElement >= this.offsets.length) {
            int oldLen = this.offsets.length;
            this.offsets = ArrayUtil.grow(this.offsets, this.offsets.length + 1);
            this.bytesUsed.addAndGet((this.offsets.length - oldLen) * 4);
        }
        this.pool.append(bytes);
        this.offsets[this.lastElement++] = this.currentOffset;
        this.currentOffset += bytes.length;
        return this.lastElement - 1;
    }

    public int size() {
        return this.lastElement;
    }

    public BytesRef get(BytesRef spare, int index) {
        if (this.lastElement > index) {
            int length;
            int offset = this.offsets[index];
            int n = length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
            assert (spare.offset == 0);
            spare.grow(length);
            spare.length = length;
            this.pool.readBytes(offset, spare.bytes, spare.offset, spare.length);
            return spare;
        }
        throw new IndexOutOfBoundsException("index " + index + " must be less than the size: " + this.lastElement);
    }

    private int[] sort(final Comparator<BytesRef> comp) {
        final int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        new IntroSorter(){
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratch1 = new BytesRef();
            private final BytesRef scratch2 = new BytesRef();

            @Override
            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }

            @Override
            protected int compare(int i, int j) {
                int idx1 = orderedEntries[i];
                int idx2 = orderedEntries[j];
                return comp.compare(BytesRefArray.this.get(this.scratch1, idx1), BytesRefArray.this.get(this.scratch2, idx2));
            }

            @Override
            protected void setPivot(int i) {
                int index = orderedEntries[i];
                BytesRefArray.this.get(this.pivot, index);
            }

            @Override
            protected int comparePivot(int j) {
                int index = orderedEntries[j];
                return comp.compare(this.pivot, BytesRefArray.this.get(this.scratch2, index));
            }
        }.sort(0, this.size());
        return orderedEntries;
    }

    public BytesRefIterator iterator() {
        return this.iterator(null);
    }

    public BytesRefIterator iterator(final Comparator<BytesRef> comp) {
        final BytesRef spare = new BytesRef();
        final int size = this.size();
        final int[] indices = comp == null ? null : this.sort(comp);
        return new BytesRefIterator(){
            int pos = 0;

            @Override
            public BytesRef next() {
                if (this.pos < size) {
                    int n;
                    if (indices == null) {
                        int n2 = this.pos;
                        n = n2;
                        this.pos = n2 + 1;
                    } else {
                        n = indices[this.pos++];
                    }
                    return BytesRefArray.this.get(spare, n);
                }
                return null;
            }

            @Override
            public Comparator<BytesRef> getComparator() {
                return comp;
            }
        };
    }
}

