/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.ConfigurationParameter;
import fitnesse.components.ComponentInstantiationException;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class ComponentFactory {
    private final Properties properties;

    public ComponentFactory(Properties properties) {
        this.properties = properties;
    }

    public Object createComponent(String componentType, Class<?> defaultComponent) throws ComponentInstantiationException {
        Class<?> componentClass;
        String componentClassName = this.properties.getProperty(componentType);
        try {
            componentClass = componentClassName != null ? Class.forName(componentClassName) : defaultComponent;
        }
        catch (Exception e) {
            throw new ComponentInstantiationException("Unable to look up component for type " + componentType, e);
        }
        if (componentClass != null) {
            return this.createComponent(componentClass);
        }
        return null;
    }

    public <T> T createComponent(Class<T> componentClass) throws ComponentInstantiationException {
        try {
            try {
                Constructor<T> constructor = componentClass.getConstructor(ComponentFactory.class);
                return constructor.newInstance(this);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<T> constructor = componentClass.getConstructor(Properties.class);
                    return constructor.newInstance(this.properties);
                }
                catch (NoSuchMethodException e2) {
                    Constructor<T> constructor = componentClass.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new ComponentInstantiationException("Unable to instantiate component for type " + componentClass.getName(), e);
        }
    }

    public Object createComponent(ConfigurationParameter componentType, Class<?> defaultComponent) {
        return this.createComponent(componentType.getKey(), defaultComponent);
    }

    public Object createComponent(ConfigurationParameter componentType) {
        return this.createComponent(componentType, null);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

