/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.ResponseSender;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public abstract class Response {
    protected static final String CRLF = "\r\n";
    private int status = 200;
    private HashMap<String, String> headers = new HashMap(17);
    private String contentType = Format.access$000(Format.HTML);
    private boolean withHttpHeaders = true;
    private static final Map<Integer, String> reasonCodes = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(100, "Continue");
            this.put(101, "Switching Protocols");
            this.put(200, "OK");
            this.put(201, "Created");
            this.put(202, "Accepted");
            this.put(203, "Non-Authoritative Information");
            this.put(204, "No Content");
            this.put(205, "Reset Content");
            this.put(300, "Multiple Choices");
            this.put(301, "Moved Permanently");
            this.put(302, "Found");
            this.put(303, "See Other");
            this.put(304, "Not Modified");
            this.put(305, "Use Proxy");
            this.put(307, "Temporary Redirect");
            this.put(400, "Bad Request");
            this.put(401, "Unauthorized");
            this.put(402, "Payment Required");
            this.put(403, "Forbidden");
            this.put(404, "Not Found");
            this.put(405, "Method Not Allowed");
            this.put(406, "Not Acceptable");
            this.put(407, "Proxy Authentication Required");
            this.put(408, "Request Time-out");
            this.put(409, "Conflict");
            this.put(410, "Gone");
            this.put(411, "Length Required");
            this.put(412, "Precondition Failed");
            this.put(413, "Request Entity Too Large");
            this.put(414, "Request-URI Too Large");
            this.put(415, "Unsupported Media Type");
            this.put(416, "Requested range not satisfiable");
            this.put(417, "SlimExpectation Failed");
            this.put(500, "Internal Server Error");
            this.put(501, "Not Implemented");
            this.put(502, "Bad Gateway");
            this.put(503, "Service Unavailable");
            this.put(504, "Gateway Time-out");
            this.put(505, "HTTP Version not supported");
        }
    };

    public static SimpleDateFormat makeStandardHttpDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    public Response(String formatString) {
        Format format = "html".equalsIgnoreCase(formatString) ? Format.HTML : ("xml".equalsIgnoreCase(formatString) ? Format.XML : ("text".equalsIgnoreCase(formatString) ? Format.TEXT : Format.HTML));
        this.setContentType(format.getContentType());
    }

    public Response(String format, int status) {
        this(format);
        this.status = status;
    }

    public boolean isXmlFormat() {
        return Format.XML.contentType.equals(this.contentType);
    }

    public boolean isHtmlFormat() {
        return Format.HTML.contentType.equals(this.contentType);
    }

    public boolean isTextFormat() {
        return Format.TEXT.contentType.equals(this.contentType);
    }

    public boolean hasContent() {
        return this.contentType != null;
    }

    public abstract void sendTo(ResponseSender var1) throws IOException;

    public abstract int getContentSize();

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public void withoutHttpHeaders() {
        this.withHttpHeaders = false;
    }

    public final String makeHttpHeaders() {
        if (!this.withHttpHeaders) {
            return "";
        }
        if (this.hasContent()) {
            this.addContentHeaders();
        }
        StringBuffer text = new StringBuffer();
        if (!Format.TEXT.contentType.equals(this.contentType)) {
            text.append("HTTP/1.1 ").append(this.status).append(" ").append(this.getReasonPhrase()).append(CRLF);
            this.makeHeaders(text);
            text.append(CRLF);
        }
        return text.toString();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    private void noContent() {
        this.contentType = null;
    }

    public void setContentType(Format format) {
        this.contentType = format.getContentType();
    }

    public void redirect(String contextRoot, String location) {
        this.status = 303;
        this.addHeader("Location", contextRoot + location);
    }

    public void notModified(Date lastModified, Date date) {
        this.status = 304;
        this.noContent();
        SimpleDateFormat httpDateFormat = Response.makeStandardHttpDateFormat();
        this.addHeader("Date", httpDateFormat.format(date));
        this.setLastModifiedHeader(lastModified);
        this.addHeader("Cache-Control", "private");
    }

    public void setMaxAge(int age) {
        this.addHeader("Cache-Control", "max-age=" + age);
    }

    public void setLastModifiedHeader(Date date) {
        this.addHeader("Last-Modified", Response.makeStandardHttpDateFormat().format(date));
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public byte[] getEncodedBytes(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to encode data", e);
        }
    }

    void makeHeaders(StringBuffer text) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            text.append(entry.getKey()).append(": ").append(entry.getValue()).append(CRLF);
        }
    }

    protected void addContentHeaders() {
        this.addHeader("Content-Type", this.getContentType());
    }

    protected String getReasonPhrase() {
        return Response.getReasonPhrase(this.status);
    }

    public static String getReasonPhrase(int status) {
        String reasonPhrase = reasonCodes.get(status);
        return reasonPhrase == null ? "Unknown Status" : reasonPhrase;
    }

    public static enum Format {
        XML("text/xml"),
        HTML("text/html; charset=utf-8"),
        TEXT("text/text"),
        JSON("text/json");

        private final String contentType;

        private Format(String contentType) {
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

