/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseContext;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestXmlFormatter;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.PageType;
import fitnesse.wiki.WikiPage;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import util.TimeMeasurement;

public class SuiteHistoryFormatter
extends BaseFormatter
implements Closeable {
    private SuiteExecutionReport.PageHistoryReference referenceToCurrentTest;
    private SuiteExecutionReport suiteExecutionReport;
    private final TimeMeasurement totalTimeMeasurement;
    private TestXmlFormatter.WriterFactory writerFactory;
    private TimeMeasurement suiteTime;
    private TestXmlFormatter testHistoryFormatter;

    public SuiteHistoryFormatter(FitNesseContext context, WikiPage page, TestXmlFormatter.WriterFactory source) {
        super(context, page);
        this.writerFactory = source;
        this.suiteExecutionReport = new SuiteExecutionReport(context.version, this.getPage().getPageCrawler().getFullPath().toString());
        this.totalTimeMeasurement = new TimeMeasurement().start();
    }

    @Override
    public void testSystemStarted(TestSystem testSystem) {
        if (this.suiteTime == null) {
            this.suiteTime = new TimeMeasurement().start();
        }
    }

    @Override
    public void testSystemStopped(TestSystem testSystem, Throwable cause) {
        super.testSystemStopped(testSystem, cause);
    }

    @Override
    public void testStarted(WikiTestPage test) {
        String pageName = test.getFullPath();
        this.testHistoryFormatter = new TestXmlFormatter(this.context, test.getSourcePage(), this.writerFactory);
        this.testHistoryFormatter.testStarted(test);
        this.referenceToCurrentTest = new SuiteExecutionReport.PageHistoryReference(pageName, this.testHistoryFormatter.startedAt());
    }

    @Override
    public void testOutputChunk(String output) {
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.testOutputChunk(output);
        }
    }

    @Override
    public void testComplete(WikiTestPage test, TestSummary testSummary) throws IOException {
        this.testHistoryFormatter.testComplete(test, testSummary);
        this.testHistoryFormatter.close();
        this.referenceToCurrentTest.setTestSummary(testSummary);
        this.referenceToCurrentTest.setRunTimeInMillis(this.testHistoryFormatter.runTime());
        this.suiteExecutionReport.addPageHistoryReference(this.referenceToCurrentTest);
        this.suiteExecutionReport.tallyPageCounts(ExecutionResult.getExecutionResult(test.getName(), testSummary));
        this.testHistoryFormatter = null;
        super.testComplete(test, testSummary);
    }

    @Override
    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        this.testHistoryFormatter.testAssertionVerified(assertion, testResult);
        super.testAssertionVerified(assertion, testResult);
    }

    @Override
    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        this.testHistoryFormatter.testExceptionOccurred(assertion, exceptionResult);
        super.testExceptionOccurred(assertion, exceptionResult);
    }

    @Override
    public void errorOccurred(Throwable cause) {
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.errorOccurred(cause);
        }
        super.errorOccurred(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.suiteTime == null || this.suiteTime.isStopped()) {
            return;
        }
        this.suiteTime.stop();
        this.totalTimeMeasurement.stop();
        this.suiteExecutionReport.setTotalRunTimeInMillis(this.totalTimeMeasurement);
        if (this.testHistoryFormatter != null) {
            this.testHistoryFormatter.close();
        }
        if (PageType.fromWikiPage(this.getPage()) == PageType.SUITE) {
            Writer writer = this.writerFactory.getWriter(this.context, this.getPage(), this.getPageCounts(), this.suiteTime.startedAt());
            try {
                VelocityContext velocityContext = new VelocityContext();
                velocityContext.put("suiteExecutionReport", this.getSuiteExecutionReport());
                VelocityEngine velocityEngine = this.context.pageFactory.getVelocityEngine();
                Template template = velocityEngine.getTemplate("suiteHistoryXML.vm");
                template.merge(velocityContext, writer);
            }
            finally {
                writer.close();
            }
        }
    }

    @Override
    public int getErrorCount() {
        return this.getPageCounts().getWrong() + this.getPageCounts().getExceptions();
    }

    public List<SuiteExecutionReport.PageHistoryReference> getPageHistoryReferences() {
        return this.suiteExecutionReport.getPageHistoryReferences();
    }

    public TestSummary getPageCounts() {
        return this.suiteExecutionReport.getFinalCounts();
    }

    public SuiteExecutionReport getSuiteExecutionReport() {
        return this.suiteExecutionReport;
    }
}

