/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.components.TraversalListener;
import fitnesse.components.Traverser;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.IOException;

public class WikiImportingTraverser
implements WikiImporterClient,
Traverser<Object> {
    private final WikiImporter importer;
    private final WikiPage page;
    private final PageData data;
    private final boolean isUpdate;
    private final boolean isNonRoot;
    private final String remoteWikiUrl;
    private final WikiPagePath pagePath;
    private TraversalListener<Object> traversalListener;

    public WikiImportingTraverser(WikiImporter wikiImporter, WikiPage page, String remoteWikiUrl) throws IOException {
        this.importer = wikiImporter;
        this.page = page;
        this.data = page.getData();
        this.pagePath = page.getPageCrawler().getFullPath();
        WikiImportProperty importProperty = WikiImportProperty.createFrom(this.data.getProperties());
        if (importProperty != null) {
            this.remoteWikiUrl = importProperty.getSourceUrl();
            this.isUpdate = true;
            this.isNonRoot = !importProperty.isRoot();
        } else {
            this.remoteWikiUrl = remoteWikiUrl;
            this.isUpdate = false;
            this.isNonRoot = false;
        }
        this.initializeImporter();
    }

    public WikiImportingTraverser(WikiImporter wikiImporter, WikiPage page) throws IOException {
        this(wikiImporter, page, null);
    }

    private void initializeImporter() throws IOException {
        this.importer.setWikiImporterClient(this);
        this.importer.setLocalPath(this.pagePath);
        this.importer.parseUrl(this.remoteWikiUrl);
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    public void traverse(TraversalListener<Object> traversalListener) {
        this.traversalListener = traversalListener;
        try {
            if (this.isNonRoot) {
                this.importer.importRemotePageContent(this.page);
            }
            this.importer.importWiki(this.page);
            if (!this.isUpdate) {
                WikiImportProperty importProperty = new WikiImportProperty(this.importer.remoteUrl());
                importProperty.setRoot(true);
                importProperty.setAutoUpdate(this.importer.getAutoUpdateSetting());
                importProperty.addTo(this.data.getProperties());
                this.page.commit(this.data);
            }
        }
        catch (WikiImporter.WikiImporterException e) {
            traversalListener.process(new ImportError("ERROR", "The remote resource, " + this.importer.remoteUrl() + ", was not found."));
        }
        catch (WikiImporter.AuthenticationRequiredException e) {
            traversalListener.process(new ImportError("AUTH", e.getMessage()));
        }
        catch (Exception e) {
            traversalListener.process(new ImportError("ERROR", e.getMessage(), e));
        }
    }

    @Override
    public void pageImported(WikiPage localPage) {
        this.traversalListener.process(localPage);
    }

    @Override
    public void pageImportError(WikiPage localPage, Exception e) {
        this.traversalListener.process(new ImportError("PAGEERROR", e.getMessage(), e));
    }

    public static class ImportError {
        private String message;
        private String type;
        private Exception exception;

        public ImportError(String type, String message) {
            this(type, message, null);
        }

        public ImportError(String type, String message, Exception exception) {
            this.type = type;
            this.message = message;
            this.exception = exception;
        }

        public String getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.exception;
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.getMessage();
        }
    }
}

