/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.TemplateUtil;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class NewPageResponder
implements Responder {
    public static final String DEFAULT_PAGE_CONTENT_PROPERTY = "newpage.default.content";
    public static final String DEFAULT_PAGE_CONTENT = "!contents -R2 -g -p -f -h";
    public static final String PAGE_TEMPLATE = "pageTemplate";
    public static final String PAGE_TYPE = "pageType";
    public static final String PAGE_TYPES = "pageTypes";

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        SimpleResponse response = new SimpleResponse();
        response.setContent(this.doMakeHtml(context, request));
        return response;
    }

    private String doMakeHtml(FitNesseContext context, Request request) {
        HtmlPage html = context.pageFactory.newPage();
        html.setTitle("New page");
        html.setPageTitle(new PageTitle("New Page", PathParser.parse(request.getResource())));
        html.setMainTemplate("editPage");
        this.makeEditForm(html, context, request);
        return html.html();
    }

    private void makeEditForm(HtmlPage html, FitNesseContext context, Request request) {
        html.put("resource", request.getResource());
        html.put("isNewPage", true);
        html.put("helpText", "");
        WikiPage parentWikiPage = this.getParentWikiPage(context, request);
        html.put("templateMap", TemplateUtil.getTemplateMap(parentWikiPage));
        if (request.hasInput(PAGE_TEMPLATE)) {
            PageCrawler crawler = context.root.getPageCrawler();
            String pageTemplate = (String)request.getInput(PAGE_TEMPLATE);
            WikiPage template = crawler.getPage(PathParser.parse(pageTemplate));
            html.put("pageContent", template.getData().getContent());
            html.put(PAGE_TYPE, (Object)PageType.fromWikiPage(template));
            html.put(PAGE_TEMPLATE, pageTemplate);
        } else if (request.hasInput(PAGE_TYPE)) {
            String pageType = (String)request.getInput(PAGE_TYPE);
            PageType.fromString(pageType);
            html.put(PAGE_TYPE, pageType);
            html.put("pageContent", NewPageResponder.getDefaultContent(parentWikiPage));
        } else {
            html.put(PAGE_TYPES, PageData.PAGE_TYPE_ATTRIBUTES);
            html.put("pageContent", NewPageResponder.getDefaultContent(parentWikiPage));
        }
    }

    public static String getDefaultContent(WikiPage page) {
        String content = page.getVariable(DEFAULT_PAGE_CONTENT_PROPERTY);
        if (content == null) {
            content = DEFAULT_PAGE_CONTENT;
        }
        return content;
    }

    private WikiPage getParentWikiPage(FitNesseContext context, Request request) {
        WikiPagePath parentPath = PathParser.parse(request.getResource());
        PageCrawler crawler = context.root.getPageCrawler();
        WikiPage page = crawler.getPage(parentPath);
        return page;
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

