/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import util.FileUtil;

public class DirectoryResponder
implements SecureResponder {
    private String resource;
    private File requestedDirectory;
    private FitNesseContext context;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy, hh:mm a");

    public DirectoryResponder(String resource, File requestedFile) {
        this.resource = resource;
        this.requestedDirectory = requestedFile;
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        SimpleResponse simpleResponse = new SimpleResponse();
        if (!this.resource.endsWith("/")) {
            this.setRedirectForDirectory(simpleResponse);
        } else {
            simpleResponse.setContent(this.makeDirectoryListingPage());
        }
        return simpleResponse;
    }

    private void setRedirectForDirectory(Response response) {
        response.redirect(this.context.contextRoot, this.resource + "/");
    }

    private String makeDirectoryListingPage() {
        HtmlPage page = this.context.pageFactory.newPage();
        page.setTitle("Files: " + this.resource);
        page.setPageTitle(new PageTitle("Files Section", this.resource, "/"));
        page.put("fileInfoList", this.makeFileInfo(FileUtil.getDirectoryListing(this.requestedDirectory)));
        page.setMainTemplate("directoryPage");
        return page.html();
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }

    private List<FileInfo> makeFileInfo(File[] files) {
        ArrayList<FileInfo> fileInfo = new ArrayList<FileInfo>();
        for (File file : files) {
            fileInfo.add(new FileInfo(file));
        }
        return fileInfo;
    }

    public class FileInfo {
        private File file;

        public FileInfo(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public String getName() {
            String name = this.file.getName();
            if (this.file.isDirectory()) {
                name = name + "/";
            }
            return name;
        }

        public String getSize() {
            if (this.file.isDirectory()) {
                return "";
            }
            return this.file.length() + " bytes";
        }

        public String getDate() {
            return DirectoryResponder.this.dateFormat.format(new Date(this.file.lastModified()));
        }
    }
}

