/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ConverterSupport;
import fitnesse.slim.Library;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimService;
import fitnesse.slim.VariableStore;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlimExecutionContext {
    private Map<String, Object> instances = new HashMap<String, Object>();
    private List<Library> libraries = new ArrayList<Library>();
    private VariableStore variables = new VariableStore();
    private List<String> paths = new ArrayList<String>();

    public List<Library> getLibraries() {
        return Collections.unmodifiableList(this.libraries);
    }

    public void addLibrary(Library library) {
        this.libraries.add(library);
    }

    public void setVariable(String name, MethodExecutionResult value) {
        this.variables.setSymbol(name, value);
    }

    public void setVariable(String name, Object value) {
        this.setVariable(name, new MethodExecutionResult(value, Object.class));
    }

    public void create(String instanceName, String className, Object[] args) throws SlimError, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.hasStoredActor(className)) {
            this.addToInstancesOrLibrary(instanceName, this.getStoredActor(className));
        } else {
            String replacedClassName = this.variables.replaceSymbolsInString(className);
            Object instance = this.createInstanceOfConstructor(replacedClassName, this.replaceSymbols(args));
            this.addToInstancesOrLibrary(instanceName, instance);
        }
    }

    public void addPath(String path) {
        if (!this.paths.contains(path)) {
            this.paths.add(path);
        }
    }

    public Object getInstance(String instanceName) {
        Object instance = this.instances.get(instanceName);
        if (instance != null) {
            return instance;
        }
        for (Library library : this.libraries) {
            if (!library.instanceName.equals(instanceName)) continue;
            return library.instance;
        }
        throw new SlimError(String.format("message:<<%s %s>>", "NO_INSTANCE", instanceName));
    }

    private void addToInstancesOrLibrary(String instanceName, Object instance) {
        if (this.isLibrary(instanceName)) {
            this.libraries.add(new Library(instanceName, instance));
        } else {
            this.setInstance(instanceName, instance);
        }
    }

    public void setInstance(String instanceName, Object instance) {
        this.instances.put(instanceName, instance);
    }

    private boolean hasStoredActor(String nameWithDollar) {
        if (!this.variables.containsValueFor(nameWithDollar)) {
            return false;
        }
        Object potentialActor = this.getStoredActor(nameWithDollar);
        return potentialActor != null && !(potentialActor instanceof String);
    }

    private Object getStoredActor(String nameWithDollar) {
        return this.variables.getStored(nameWithDollar);
    }

    private boolean isLibrary(String instanceName) {
        return instanceName.startsWith("library");
    }

    private Object createInstanceOfConstructor(String className, Object[] args) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> k = this.searchPathsForClass(className);
        Constructor<?> constructor = this.getConstructor(k.getConstructors(), args);
        if (constructor == null) {
            throw new SlimError(String.format("message:<<%s %s>>", "NO_CONSTRUCTOR", className));
        }
        return this.newInstance(args, constructor);
    }

    private Object newInstance(Object[] args, Constructor<?> constructor) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object[] initargs = ConverterSupport.convertArgs(args, constructor.getParameterTypes());
        FixtureInteraction interaction = SlimService.getInteractionClass().newInstance();
        return interaction.newInstance(constructor, initargs);
    }

    private Class<?> searchPathsForClass(String className) {
        Class<?> k = this.getClass(className);
        if (k != null) {
            return k;
        }
        ArrayList<String> reversedPaths = new ArrayList<String>(this.paths);
        Collections.reverse(reversedPaths);
        for (String path : reversedPaths) {
            k = this.getClass(path + "." + className);
            if (k == null) continue;
            return k;
        }
        throw new SlimError(String.format("message:<<%s %s>>", "NO_CLASS", className));
    }

    private Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Constructor<?> getConstructor(Constructor<?>[] constructors, Object[] args) {
        for (Constructor<?> constructor : constructors) {
            Class<?>[] arguments = constructor.getParameterTypes();
            if (arguments.length != args.length) continue;
            return constructor;
        }
        return null;
    }

    public Object[] replaceSymbols(Object[] args) {
        return this.variables.replaceSymbols(args);
    }
}

