/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.ImportInstruction;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.List;

public class ImportTable
extends SlimTable {
    public ImportTable(Table table, String id, SlimTestContext testContext) {
        super(table, id, testContext);
    }

    @Override
    protected String getTableType() {
        return "import";
    }

    @Override
    public List<SlimAssertion> getAssertions() throws SyntaxError {
        int rows = this.table.getRowCount();
        ArrayList<SlimAssertion> instructions = new ArrayList<SlimAssertion>(rows);
        if (rows < 2) {
            throw new SyntaxError("Import tables must have at least two rows.");
        }
        for (int row = 1; row < rows; ++row) {
            String importString = this.table.getCellContents(0, row);
            if (importString.length() <= 0) continue;
            ImportInstruction importInstruction = new ImportInstruction(this.makeInstructionTag(), importString);
            instructions.add(this.makeAssertion(importInstruction, new ImportExpectation(0, row)));
        }
        return instructions;
    }

    public class ImportExpectation
    extends SlimTable.RowExpectation {
        public ImportExpectation(int col, int row) {
            super(ImportTable.this, col, row);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            if ("OK".equalsIgnoreCase(actual)) {
                return SlimTestResult.ok(expected);
            }
            return SlimTestResult.error(String.format("Unknown import message: %s", actual));
        }
    }
}

