/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.RecentChanges;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import util.Clock;

public class RecentChangesWikiPage
implements RecentChanges {
    private static SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat("kk:mm:ss EEE, MMM dd, yyyy");
    }

    @Override
    public void updateRecentChanges(WikiPage page) {
        this.createRecentChangesIfNecessary(page);
        this.addCurrentPageToRecentChanges(page);
    }

    @Override
    public WikiPage toWikiPage(WikiPage root) {
        return root.getPageCrawler().getRoot().getChildPage("RecentChanges");
    }

    public List<String> getRecentChangesLines(PageData recentChangesdata) {
        String content = recentChangesdata.getContent();
        BufferedReader reader = new BufferedReader(new StringReader(content));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read recent changes", e);
        }
        return lines;
    }

    private void addCurrentPageToRecentChanges(WikiPage page) {
        WikiPage recentChanges = page.getPageCrawler().getRoot().getChildPage("RecentChanges");
        String resource = this.resource(page);
        PageData recentChangesData = recentChanges.getData();
        List<String> lines = this.getRecentChangesLines(recentChangesData);
        this.removeDuplicate(lines, resource);
        lines.add(0, this.makeRecentChangesLine(page));
        this.trimExtraLines(lines);
        String content = this.convertLinesToWikiText(lines);
        recentChangesData.setContent(content);
        recentChanges.commit(recentChangesData);
    }

    private String resource(WikiPage page) {
        WikiPagePath fullPath = page.getPageCrawler().getFullPath();
        String resource = PathParser.render(fullPath);
        return resource;
    }

    private void createRecentChangesIfNecessary(WikiPage page) {
        PageCrawler crawler = page.getPageCrawler();
        WikiPage root = crawler.getRoot();
        if (!root.hasChildPage("RecentChanges")) {
            WikiPageUtil.addPage(root, PathParser.parse("RecentChanges"), "");
        }
    }

    private String makeRecentChangesLine(WikiPage page) {
        String user = page.getData().getAttribute("LastModifyingUser");
        if (user == null) {
            user = "";
        }
        return "|" + this.resource(page) + "|" + user + "|" + RecentChangesWikiPage.makeDateFormat().format(Clock.currentDate()) + "|";
    }

    private void removeDuplicate(List<String> lines, String resource) {
        ListIterator<String> iterator = lines.listIterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!s.startsWith("|" + resource + "|")) continue;
            iterator.remove();
        }
    }

    private String convertLinesToWikiText(List<String> lines) {
        StringBuffer buffer = new StringBuffer();
        for (String s : lines) {
            buffer.append(s).append("\n");
        }
        return buffer.toString();
    }

    private void trimExtraLines(List<String> lines) {
        while (lines.size() > 100) {
            lines.remove(100);
        }
    }
}

