/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.Maybe;

public class Expression {
    private String s;
    private String x;
    private boolean isInvalid;

    private double term() {
        double ans = 0.0;
        StringBuffer temp = new StringBuffer();
        while (this.s.length() > 0 && Character.isDigit(this.s.charAt(0))) {
            temp.append(Integer.parseInt("" + this.s.charAt(0)));
            this.advance();
        }
        if (this.s.length() > 0 && this.s.charAt(0) == '.') {
            temp.append('.');
            this.advance();
            while (this.s.length() > 0 && Character.isDigit(this.s.charAt(0))) {
                temp.append(Integer.parseInt("" + this.s.charAt(0)));
                this.advance();
            }
        }
        if (this.s.length() > 0 && (this.s.charAt(0) == 'e' || this.s.charAt(0) == 'E')) {
            temp.append('e');
            this.advance();
            temp.append(this.s.charAt(0));
            this.advance();
            while (this.s.length() > 0 && Character.isDigit(this.s.charAt(0))) {
                temp.append(Integer.parseInt("" + this.s.charAt(0)));
                this.advance();
            }
        }
        if (temp.length() == 0) {
            this.isInvalid = true;
        } else {
            ans = Double.valueOf(temp.toString());
        }
        return ans;
    }

    private double paren() {
        double ans;
        if (this.s.charAt(0) == '(') {
            this.advance();
            ans = this.add();
            this.advance();
        } else {
            ans = this.term();
        }
        return ans;
    }

    private double exp() {
        boolean neg = false;
        if (this.s.charAt(0) == '-') {
            neg = true;
            this.advance();
        }
        double result = this.paren();
        while (this.s.length() > 0 && this.s.charAt(0) == '^') {
            result = this.exponentiate(result);
        }
        if (neg) {
            result *= -1.0;
        }
        return result;
    }

    private double exponentiate(double result) {
        this.advance();
        boolean expNeg = false;
        if (this.s.charAt(0) == '-') {
            expNeg = true;
            this.advance();
        }
        double e = this.paren();
        result = result < 0.0 ? this.exponentiateNegativeNumber(result, expNeg, e) : (expNeg ? Math.exp(-e * Math.log(result)) : Math.exp(e * Math.log(result)));
        return result;
    }

    private void advance() {
        this.s = this.s.substring(1);
    }

    private double exponentiateNegativeNumber(double result, boolean expNeg, double e) {
        result = Math.ceil(e) == e ? this.calculateIntegralExponent(result, expNeg, e) : Double.NaN;
        return result;
    }

    private double calculateIntegralExponent(double result, boolean expNeg, double e) {
        double x = 1.0;
        if (expNeg) {
            e *= -1.0;
        }
        if (e == 0.0) {
            result = 1.0;
        } else if (e > 0.0) {
            int i = 0;
            while ((double)i < e) {
                x *= result;
                ++i;
            }
        } else {
            int i = 0;
            while ((double)i < -e) {
                x /= result;
                ++i;
            }
        }
        result = x;
        return result;
    }

    private double trig() {
        double ans = 0.0;
        boolean found = false;
        if (this.s.indexOf("sin") == 0) {
            this.s = this.s.substring(3);
            ans = Math.sin(this.trig());
            found = true;
        } else if (this.s.indexOf("cos") == 0) {
            this.s = this.s.substring(3);
            ans = Math.cos(this.trig());
            found = true;
        } else if (this.s.indexOf("tan") == 0) {
            this.s = this.s.substring(3);
            ans = Math.tan(this.trig());
            found = true;
        }
        if (!found) {
            ans = this.exp();
        }
        return ans;
    }

    private double mul() {
        double ans = this.trig();
        if (this.s.length() > 0) {
            while (this.s.length() > 0) {
                if (this.s.charAt(0) == '*') {
                    this.advance();
                    ans *= this.trig();
                    continue;
                }
                if (this.s.charAt(0) != '/') break;
                this.advance();
                ans /= this.trig();
            }
        }
        return ans;
    }

    private double add() {
        double ans = this.mul();
        while (this.s.length() > 0) {
            if (this.s.charAt(0) == '+') {
                this.advance();
                ans += this.mul();
                continue;
            }
            if (this.s.charAt(0) != '-') break;
            this.advance();
            ans -= this.mul();
        }
        return ans;
    }

    public Maybe<Double> evaluate() {
        this.isInvalid = false;
        this.s = this.x.intern();
        double last = this.add();
        return this.isInvalid ? Maybe.noDouble : new Maybe<Double>(last);
    }

    public Expression(String s) {
        this.x = s.replaceAll("[ \t]", "");
    }

    public String toString() {
        return this.x.intern();
    }
}

