/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public final class RegexTestCase {
    private RegexTestCase() {
    }

    public static void assertMatches(String regexp, String string) {
        RegexTestCase.assertHasRegexp(regexp, string);
    }

    public static void assertNotMatches(String regexp, String string) {
        RegexTestCase.assertDoesntHaveRegexp(regexp, string);
    }

    public static void assertHasRegexp(String regexp, String output) {
        Matcher match = Pattern.compile(regexp, 40).matcher(output);
        boolean found = match.find();
        if (!found) {
            Assert.fail((String)("The regexp <" + regexp + "> was not found in: " + output + "."));
        }
    }

    public static void assertDoesntHaveRegexp(String regexp, String output) {
        Matcher match = Pattern.compile(regexp, 8).matcher(output);
        boolean found = match.find();
        if (found) {
            Assert.fail((String)("The regexp <" + regexp + "> was found."));
        }
    }

    public static void assertSubString(String substring, String string) {
        if (!string.contains(substring)) {
            Assert.fail((String)("substring '" + substring + "' not found in string '" + string + "'."));
        }
    }

    public static void assertNotSubString(String subString, String string) {
        if (string.contains(subString)) {
            Assert.fail((String)("expecting substring:'" + subString + "' in string:'" + string + "'."));
        }
    }

    public static String divWithIdAndContent(String id, String expectedDivContent) {
        return "<div.*?id=\"" + id + "\".*?>" + expectedDivContent + "</div>";
    }
}

