/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain.freemarker;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xltest.domain.TestRun;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class Report
extends com.xebialabs.xltest.domain.Report {
    private static Logger LOG = LoggerFactory.getLogger(Report.class);
    @Property(required=false)
    private Map<String, String> contextProperties = new HashMap<String, String>();
    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    @Override
    public String compute(TestRun testRun) {
        String format;
        try {
            format = this.readTemplateFile(this.getScriptLocation());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not perform freemarker report transformation.", e);
        }
        HashMap<String, Object> templateProperties = new HashMap<String, Object>(this.getAttributes());
        templateProperties.put("testRuns", this.getTestRunsRepository());
        templateProperties.put("testRun", testRun);
        templateProperties.put("testSpecification", this.getRepository().read("Configuration/TestSpecifications/" + testRun.getTestSpecificationName()));
        templateProperties.put("this", this);
        this.injectContextProperties(templateProperties);
        for (String key : templateProperties.keySet()) {
            LOG.debug("freemarker report has context property: " + key + " with value: " + templateProperties.get(key) + " (instance of " + templateProperties.get(key).getClass().getName() + ")");
        }
        return this.format(templateProperties, format);
    }

    private void injectContextProperties(Map<String, Object> templateProperties) {
        for (Map.Entry<String, String> entry : this.contextProperties.entrySet()) {
            Object instance = null;
            try {
                instance = Class.forName(entry.getValue()).newInstance();
            }
            catch (Exception e) {
                LOG.error("Can't inject " + entry.getKey() + " of type " + entry.getValue() + " into the freekmarker context");
                e.printStackTrace();
            }
            this.beanFactory.autowireBean(instance);
            templateProperties.put(entry.getKey(), instance);
        }
    }

    private String readTemplateFile(String fileName) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/" + fileName);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    private String format(Map<String, Object> properties, String format) {
        try {
            Configuration cfg = new Configuration();
            cfg.clearTemplateCache();
            Template t = new Template(this.getScriptLocation(), (Reader)new StringReader(format), cfg);
            StringWriter sw = new StringWriter();
            t.process(properties, (Writer)sw);
            return sw.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        catch (TemplateException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String nextDate(Date date) {
        Date nextDate = new Date(date.getTime() + 86400000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(nextDate);
    }

    public String previousDate(Date date) {
        Date previousDate = new Date(date.getTime() - 86400000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(previousDate);
    }

    public String thisDay(Long date) {
        SimpleDateFormat format = new SimpleDateFormat("dd");
        return format.format(new Date(date));
    }

    public String getAttributeAsString(String key) {
        if (this.getAttributes() != null) {
            return this.getAttributes().get(key).toString();
        }
        return "";
    }
}

