package com.xebialabs.xltest.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xltest.repository.TestRunsRepository;

@Metadata(description = "Base type for test run qualifiers", root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Qualification extends ScriptedConfigurationItem {

    private static final Logger LOG = LoggerFactory.getLogger(Qualification.class);

    public Qualifier getQualifier(final UUID testRunId, final TestRunsRepository testRunsRepository) {
        return new Qualifier() {
            private List<Event> events = new ArrayList<>();

            @Override
            public void update(Event event) {
                events.add(event);
            }

            @Override
            public Boolean getQualificationResult() {
                ScriptContext context = newScriptContext();
                context.setAttribute("events", events, ScriptContext.ENGINE_SCOPE);
                context.setAttribute("testRun", testRunsRepository.getTestRunFromEvents(events), ScriptContext.ENGINE_SCOPE);
                context.setAttribute("testRuns", testRunsRepository, ScriptContext.ENGINE_SCOPE);
                try {
                    Object result = execute(context, Qualification.this);
                    return (Boolean) result;
                } catch (Exception e) {
                    throw new RuntimeException("Could not perform qualification of the run.", e);
                }
            }

            @Override
            public Event getEvent() {
                if (events.size() == 0) {
                    return new Event(testRunId, Event.QUALIFICATION_COMPUTED, Event.props(Event.QUALIFICATION, Boolean.FALSE,
                            Event.FAILURE_REASON, "No events have been found"));
                }

                try {
                    return new Event(testRunId, Event.QUALIFICATION_COMPUTED, Event.props(Event.QUALIFICATION, getQualificationResult()));
                } catch (Exception e) {
                    LOG.warn("Unable to calculate qualification for test run {}: {}", testRunId, e.getMessage());
                    LOG.debug("Qualification calculation error", e);
                    return new Event(testRunId, Event.QUALIFICATION_COMPUTED, Event.props(Event.QUALIFICATION, Boolean.FALSE,
                            Event.FAILURE_REASON, "Could not calculate qualification: " + e.getMessage()));
                }
            }
        };
    }
}
