/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.domain.Qualification;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.view.ExecutionParameterRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

@Metadata(description="Grouping construct for test specification", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class TestSpecificationSet
extends BaseTestSpecification
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationSet.class);
    @Property
    private List<BaseTestSpecification> testSpecifications = Collections.emptyList();
    @Property(description="The report used to determine the outcome of a test run (success/fail)", required=false)
    private Qualification qualification;
    @Autowired
    private transient AutowireCapableBeanFactory beanFactory;

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void execute(UUID testRunId, Map<String, Object> parameters, final EventHandler eventHandler) {
        try {
            eventHandler.onReceive(this.parentStartEvent(testRunId));
            final CompositeExecutionQualifier qualifier = new CompositeExecutionQualifier(testRunId);
            for (BaseTestSpecification baseTestSpecification : this.testSpecifications) {
                if (!(baseTestSpecification instanceof Executable)) continue;
                Executable executable = (Executable)((Object)baseTestSpecification);
                this.beanFactory.autowireBean((Object)executable);
                UUID childRunId = UUID.randomUUID();
                eventHandler.onReceive(this.childStartEvent(testRunId, childRunId));
                executable.execute(childRunId, parameters, new EventHandler(){

                    @Override
                    public void onReceive(Event event) throws Exception {
                        eventHandler.onReceive(event);
                        qualifier.update(event);
                    }
                });
                eventHandler.onReceive(this.childFinishedEvent(testRunId, childRunId));
            }
            eventHandler.onReceive(new Event(qualifier.getEvent(), Event.props((Object[])new Object[]{"testSpecification", this.getName()})));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                eventHandler.onReceive(this.parentFinishedEvent(testRunId));
            }
            catch (Exception e) {
                LOG.error("Unable to handle finish event", (Throwable)e);
            }
        }
    }

    @Override
    public boolean updateExecutionProperties(String commandLine, Host hostId) {
        return false;
    }

    @Override
    public ExecutionParameterRequest toExecutionParameterRequest() {
        return new ExecutionParameterRequest("super", "super", this.getParameters());
    }

    public Map<String, Set<String>> getParameters() {
        HashMap<String, Set<String>> parameters = new HashMap<String, Set<String>>();
        for (BaseTestSpecification eachChildTestSpec : this.getTestSpecifications()) {
            if (!(eachChildTestSpec instanceof Executable)) continue;
            ExecutionParameterRequest executionParameterRequest = ((Executable)((Object)eachChildTestSpec)).toExecutionParameterRequest();
            this.mergeParameters(parameters, executionParameterRequest.getParameters());
        }
        return parameters;
    }

    private void mergeParameters(Map<String, Set<String>> parameters, Map<String, Set<String>> testSpecificationParameters) {
        for (Map.Entry<String, Set<String>> paramEntry : testSpecificationParameters.entrySet()) {
            if (parameters.containsKey(paramEntry.getKey())) {
                parameters.get(paramEntry.getKey()).addAll((Collection<String>)paramEntry.getValue());
                continue;
            }
            parameters.put(paramEntry.getKey(), paramEntry.getValue());
        }
    }

    private Event childFinishedEvent(UUID testRunId, UUID childRunId) {
        return new Event(testRunId, "childFinished", Event.props((Object[])new Object[]{"childRunId", childRunId.toString(), "testSpecification", this.getName()}));
    }

    private Event childStartEvent(UUID testRunId, UUID childRunId) {
        return new Event(testRunId, "childStarted", Event.props((Object[])new Object[]{"childRunId", childRunId.toString(), "testSpecification", this.getName()}));
    }

    private Event parentFinishedEvent(UUID testRunId) {
        return new Event(testRunId, "executionFinished", Event.props((Object[])new Object[]{"testSpecification", this.getName()}));
    }

    private Event parentStartEvent(UUID testRunId) {
        return new Event(testRunId, "executionStarted", Event.props((Object[])new Object[]{"testSpecification", this.getName()}));
    }

    public List<BaseTestSpecification> getTestSpecifications() {
        return this.testSpecifications;
    }

    public void setTestSpecifications(List<BaseTestSpecification> testSpecifications) {
        this.testSpecifications = testSpecifications;
    }

    @Override
    public Qualification getQualification() {
        return this.qualification;
    }

    @Override
    public void setQualification(Qualification qualification) {
        this.qualification = qualification;
    }

    private static class CompositeExecutionQualifier
    implements Qualifier {
        private final UUID testRunId;
        Boolean qualification = true;

        public CompositeExecutionQualifier(UUID testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public void update(Event event) {
            if (this.qualification.booleanValue() && "qualificationComputed".equals(event.getType())) {
                this.qualification = this.qualification != false && (Boolean)event.get("qualification") != false;
            }
        }

        @Override
        public Boolean getQualificationResult() {
            return this.qualification;
        }

        @Override
        public Event getEvent() {
            return new Event(this.testRunId, "qualificationComputed", Event.props((Object[])new Object[]{"qualification", this.qualification}));
        }
    }
}

