/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.serialize.BasicMessageBodyWriter;
import com.xebialabs.xltest.view.ListOfTestRuns;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.DatatypeConverter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class ListOfTestRunsWriter
extends BasicMessageBodyWriter<ListOfTestRuns> {
    @Override
    protected void writeJson(ListOfTestRuns testRuns, JSONWriter writer) throws JSONException {
        writer.array();
        for (TestRun testRun : testRuns) {
            this.writeJson(testRun, writer);
        }
        writer.endArray();
    }

    @Override
    protected void writeJson(TestRun testRun, JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("id").value((Object)testRun.getId());
        writer.key("startTime").value((Object)this.convert(testRun.getStartTime()));
        writer.key("finishedTime").value((Object)this.convert(testRun.getFinishedTime()));
        writer.key("qualificationResult").value(testRun.getQualificationResult());
        writer.key("testSpecificationName").value((Object)testRun.getTestSpecificationName());
        writer.endObject();
    }

    private String convert(Date value) {
        if (value == null) {
            return null;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(value);
        return DatatypeConverter.printDateTime((Calendar)cal);
    }
}

