/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.gatling;

import com.google.common.io.Files;
import com.xebialabs.xltest.gatling.GatlingGlobalStatsReport;
import com.xebialabs.xltest.utils.JsonResponseParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;

public class GatlingGlobalStatsJsonParser {
    public static GatlingGlobalStatsReport parse(File jsonReport) throws Exception {
        if (!jsonReport.exists()) {
            throw new FileNotFoundException(jsonReport.getAbsolutePath());
        }
        JsonResponseParser parser = new JsonResponseParser();
        parser.parse(Files.toString((File)jsonReport, (Charset)Charset.defaultCharset()));
        GatlingGlobalStatsReport statsReport = new GatlingGlobalStatsReport(GatlingGlobalStatsJsonParser.result(parser, "numberOfRequests")).withMinResponseTime(GatlingGlobalStatsJsonParser.result(parser, "minResponseTime")).withMaxResponseTime(GatlingGlobalStatsJsonParser.result(parser, "maxResponseTime")).withMeanResponseTime(GatlingGlobalStatsJsonParser.result(parser, "meanResponseTime")).withStandardDeviation(GatlingGlobalStatsJsonParser.result(parser, "standardDeviation")).withPercentiles1(GatlingGlobalStatsJsonParser.result(parser, "percentiles1")).withPercentiles2(GatlingGlobalStatsJsonParser.result(parser, "percentiles2")).withGroup1(GatlingGlobalStatsJsonParser.group(parser, "group1")).withGroup2(GatlingGlobalStatsJsonParser.group(parser, "group2")).withGroup3(GatlingGlobalStatsJsonParser.group(parser, "group3")).withGroup4(GatlingGlobalStatsJsonParser.group(parser, "group4")).withMeanNumberOfRequestsPerSecond(GatlingGlobalStatsJsonParser.meanRequests(parser, "meanNumberOfRequestsPerSecond"));
        return statsReport;
    }

    private static GatlingGlobalStatsReport.Result result(JsonResponseParser parser, String reportQualifier) {
        int total = (Integer)parser.getValue(reportQualifier + ".total");
        int ok = (Integer)parser.getValue(reportQualifier + ".ok");
        int ko = (Integer)parser.getValue(reportQualifier + ".ko");
        return new GatlingGlobalStatsReport.Result(total, ok, ko);
    }

    private static GatlingGlobalStatsReport.Group group(JsonResponseParser parser, String reportQualifier) {
        String name = (String)parser.getValue(reportQualifier + ".name");
        int count = (Integer)parser.getValue(reportQualifier + ".count");
        int percentage = (Integer)parser.getValue(reportQualifier + ".percentage");
        return new GatlingGlobalStatsReport.Group(name, count, percentage);
    }

    private static GatlingGlobalStatsReport.MeanRequestsPerSec meanRequests(JsonResponseParser parser, String reportQualifier) {
        Number total = (Number)parser.getValue(reportQualifier + ".total");
        Number ok = (Number)parser.getValue(reportQualifier + ".ok");
        Number ko = (Number)parser.getValue(reportQualifier + ".ko");
        return new GatlingGlobalStatsReport.MeanRequestsPerSec(total, ok, ko);
    }
}

