/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting;

import fitnesse.FitNesseContext;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.CompositeExecutionLog;
import fitnesse.reporting.ExecutionStatus;
import fitnesse.testrunner.TestsRunnerListener;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;
import java.io.IOException;

public abstract class InteractiveFormatter
extends BaseFormatter
implements TestsRunnerListener {
    private static final String TESTING_INTERRUPTED = "<strong>Testing was interrupted and results are incomplete.</strong>&nbsp;";
    private boolean wasInterrupted = false;
    private TestSummary assertionCounts = new TestSummary();
    private final CompositeExecutionLog log;
    private String relativeName;

    protected InteractiveFormatter(FitNesseContext context, WikiPage page, CompositeExecutionLog log) {
        super(context, page);
        this.log = log;
    }

    protected abstract void writeData(String var1);

    protected void updateSummaryDiv(String html) {
        this.writeData(HtmlUtil.makeReplaceElementScript("test-summary", html).html());
    }

    protected String getRelativeName() {
        return this.relativeName;
    }

    protected String getRelativeName(WikiTestPage testPage) {
        PageCrawler pageCrawler = this.getPage().getPageCrawler();
        String relativeName = pageCrawler.getRelativeName(testPage.getSourcePage());
        if ("".equals(relativeName)) {
            relativeName = String.format("(%s)", testPage.getName());
        }
        return relativeName;
    }

    protected void addStopLink(String stopResponderId) {
        String link = "?responder=stoptest&id=" + stopResponderId;
        HtmlTag status = HtmlUtil.makeSilentLink(link, new RawHtml("Stop Test"));
        status.addAttribute("class", "stop");
        this.writeData(HtmlUtil.makeReplaceElementScript("test-action", status.html()).html());
    }

    protected void removeStopTestLink() {
        HtmlTag script = HtmlUtil.makeReplaceElementScript("test-action", "");
        this.writeData(script.html());
    }

    public TestSummary getAssertionCounts() {
        return this.assertionCounts;
    }

    @Override
    public int getErrorCount() {
        return this.getAssertionCounts().getWrong() + this.getAssertionCounts().getExceptions();
    }

    @Override
    public void testSystemStopped(TestSystem testSystem, Throwable cause) {
        super.testSystemStopped(testSystem, cause);
    }

    public boolean wasInterrupted() {
        return this.wasInterrupted;
    }

    @Override
    public void errorOccurred(Throwable cause) {
        this.wasInterrupted = true;
        super.errorOccurred(cause);
    }

    @Override
    public void testStarted(WikiTestPage testPage) {
        this.relativeName = this.getRelativeName(testPage);
    }

    public String testSummary() {
        String summaryContent = this.wasInterrupted ? TESTING_INTERRUPTED : "";
        summaryContent = summaryContent + this.makeSummaryContent();
        HtmlTag script = HtmlUtil.makeReplaceElementScript("test-summary", summaryContent);
        script.add("document.getElementById(\"test-summary\").className = \"" + (Object)((Object)(this.wasInterrupted ? ExecutionResult.ERROR : ExecutionResult.getExecutionResult(this.relativeName, this.getAssertionCounts()))) + "\";");
        return script.html();
    }

    protected abstract String makeSummaryContent();

    public void finishWritingOutput() throws IOException {
        this.writeData(this.testSummary());
    }

    @Override
    public void announceNumberTestsToRun(int testsToRun) {
    }

    @Override
    public void setTrackingId(String stopResponderId) {
        this.addStopLink(stopResponderId);
    }

    protected void AddLogLink() throws IOException {
        this.writeData(HtmlUtil.makeReplaceElementScript("test-action", this.executionStatus(this.log)).html());
    }

    protected void maybeMakeErrorNavigatorVisible() {
        if (this.exceptionsOrErrorsExist()) {
            this.writeData(this.initErroMetadata());
        }
    }

    private boolean exceptionsOrErrorsExist() {
        return this.assertionCounts.getExceptions() + this.assertionCounts.getWrong() > 0;
    }

    public String executionStatus(CompositeExecutionLog log) {
        String errorLogPageName = log.getErrorLogPageName();
        if (log.exceptionCount() != 0) {
            return InteractiveFormatter.makeExecutionStatusLink(errorLogPageName, ExecutionStatus.ERROR);
        }
        if (log.hasCapturedOutput()) {
            return InteractiveFormatter.makeExecutionStatusLink(errorLogPageName, ExecutionStatus.OUTPUT);
        }
        return InteractiveFormatter.makeExecutionStatusLink(errorLogPageName, ExecutionStatus.OK);
    }

    private String initErroMetadata() {
        HtmlTag init = HtmlUtil.makeInitErrorMetadataScript();
        return init.html();
    }

    public static String makeExecutionStatusLink(String linkHref, ExecutionStatus executionStatus) {
        HtmlTag status = HtmlUtil.makeLink(linkHref, executionStatus.getMessage());
        status.addAttribute("class", executionStatus.getStyle());
        return status.html();
    }
}

